/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.formatting2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.formatting2.FormattingNotApplicableException;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.SubDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.ITextRegion;

public class TrimmedMaxLineWidthDocument
extends SubDocument {
    private final int maxLineWidth;
    private final ITextSegment astRegion;

    public TrimmedMaxLineWidthDocument(ISequentialRegion astRegion, IFormattableDocument parent, int maxLineWidth) {
        this((ITextSegment)astRegion, astRegion.merge((ITextRegion)astRegion.getNextHiddenRegion()), parent, maxLineWidth);
    }

    public TrimmedMaxLineWidthDocument(ITextSegment astRegion, ITextSegment formattableRegion, IFormattableDocument parent, int maxLineWidth) {
        super(formattableRegion, parent);
        this.astRegion = astRegion;
        this.maxLineWidth = maxLineWidth;
    }

    public void addReplacer(ITextReplacer replacer) {
        this.validate(replacer);
        super.addReplacer(replacer);
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        int formattedLength;
        ITextReplacerContext last = super.createReplacements(context);
        List replacements = last.getReplacementsUntil(context);
        String string = this.applyTextReplacementsOnAstRegion(replacements);
        if (string.contains("\n")) {
            throw new FormattingNotApplicableException();
        }
        int leadingCharCount = context.getLeadingCharsInLineCount();
        int lineLength = leadingCharCount + (formattedLength = string.length());
        if (lineLength > this.maxLineWidth) {
            throw new FormattingNotApplicableException();
        }
        return last;
    }

    protected void validate(HiddenRegionReplacer replacer) throws FormattingNotApplicableException {
        IHiddenRegionFormatting formatting = replacer.getFormatting();
        Integer newLineMin = formatting.getNewLineMin();
        if (newLineMin != null && newLineMin < 0) {
            throw new FormattingNotApplicableException();
        }
    }

    protected void validate(ITextReplacer replacer) throws FormattingNotApplicableException {
        if (replacer instanceof HiddenRegionReplacer) {
            this.validate((HiddenRegionReplacer)replacer);
        }
    }

    protected String applyTextReplacementsOnAstRegion(Iterable<ITextReplacement> replacements) {
        String input = this.astRegion.getText();
        ArrayList list = Lists.newArrayList(replacements);
        Collections.sort(list);
        int startOffset = this.astRegion.getOffset();
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        for (ITextReplacement r : list) {
            if (r.getEndOffset() <= startOffset) continue;
            if (r.getOffset() >= this.astRegion.getEndOffset()) break;
            int offset = r.getOffset() - startOffset;
            result.append(input.subSequence(lastOffset, offset));
            result.append(r.getReplacementText());
            lastOffset = offset + r.getLength();
        }
        result.append(input.subSequence(lastOffset, input.length()));
        return result.toString();
    }
}

