/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator;

import com.regnosys.rosetta.config.RosettaGeneratorsConfiguration;
import com.regnosys.rosetta.generator.AggregateGenerationException;
import com.regnosys.rosetta.generator.GenerationException;
import com.regnosys.rosetta.generator.external.ExternalGenerators;
import com.regnosys.rosetta.generator.java.JavaClassGenerator;
import com.regnosys.rosetta.generator.java.condition.ConditionGenerator;
import com.regnosys.rosetta.generator.java.enums.EnumGenerator;
import com.regnosys.rosetta.generator.java.expression.DeepPathUtilGenerator;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.function.LabelProviderGenerator;
import com.regnosys.rosetta.generator.java.object.JavaPackageInfoGenerator;
import com.regnosys.rosetta.generator.java.object.MetaFieldGenerator;
import com.regnosys.rosetta.generator.java.object.ModelMetaGenerator;
import com.regnosys.rosetta.generator.java.object.ModelObjectGenerator;
import com.regnosys.rosetta.generator.java.object.validators.CardinalityValidatorGenerator;
import com.regnosys.rosetta.generator.java.object.validators.OnlyExistsValidatorGenerator;
import com.regnosys.rosetta.generator.java.object.validators.TypeFormatValidatorGenerator;
import com.regnosys.rosetta.generator.java.reports.ReportGenerator;
import com.regnosys.rosetta.generator.java.reports.RuleGenerator;
import com.regnosys.rosetta.generator.resourcefsa.ResourceAwareFSAFactory;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.rosetta.util.DemandableLock;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaGenerator
implements IGenerator2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(RosettaGenerator.class);
    @Inject
    private EnumGenerator enumGenerator;
    @Inject
    private ModelMetaGenerator metaGenerator;
    @Inject
    private ConditionGenerator conditionGenerator;
    @Inject
    private MetaFieldGenerator metaFieldGenerator;
    @Inject
    private ExternalGenerators externalGenerators;
    @Inject
    private JavaPackageInfoGenerator javaPackageInfoGenerator;
    @Inject
    private RuleGenerator ruleGenerator;
    @Inject
    private ModelObjectGenerator dataGenerator;
    @Inject
    private CardinalityValidatorGenerator cardinalityValidatorGenerator;
    @Inject
    private TypeFormatValidatorGenerator typeFormatValidatorGenerator;
    @Inject
    private OnlyExistsValidatorGenerator onlyExistsValidatorGenerator;
    @Inject
    private FunctionGenerator funcGenerator;
    @Inject
    private ReportGenerator reportGenerator;
    @Inject
    private DeepPathUtilGenerator deepPathUtilGenerator;
    @Inject
    private LabelProviderGenerator labelProviderGenerator;
    @Inject
    private ResourceAwareFSAFactory fsaFactory;
    @Inject
    private RosettaGeneratorsConfiguration config;
    private final Set<String> ignoredFiles = Set.of("model-no-code-gen.rosetta", "basictypes.rosetta", "annotations.rosetta");
    private final Map<ResourceSet, DemandableLock> locks = new HashMap<ResourceSet, DemandableLock>();

    public void beforeAllGenerate(ResourceSet resourceSet, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        LOGGER.trace("Starting the before all generate method");
        DemandableLock lock = this.locks.computeIfAbsent(resourceSet, rs -> new DemandableLock());
        try {
            lock.getWriteLock(true);
            List models = resourceSet.getResources().stream().filter(r -> !this.isIgnoredFile((Resource)r)).map(r -> (RosettaModel)r.getContents().get(0)).filter(this::shouldGenerate).collect(Collectors.toList());
            String version = models.isEmpty() ? null : ((RosettaModel)models.get(0)).getVersion();
            this.externalGenerators.forEach(generator -> generator.beforeAllGenerate(resourceSet, models, version, map -> map.forEach((key, value) -> fsa2.generateFile(key, generator.getOutputConfiguration().getName(), value)), lock));
        }
        catch (CancellationException e) {
            LOGGER.trace("Code generation cancelled, this is expected");
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected calling before all generate for rosetta -{} - see debug logging for more", (Object)e.getMessage());
            LOGGER.debug("Unexpected calling before all generate for rosetta", (Throwable)e);
            throw new GenerationException(e.getMessage(), null, null, e.getCause());
        }
        finally {
            lock.releaseWriteLock();
        }
    }

    public void beforeGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        if (!this.isIgnoredFile(resource)) {
            LOGGER.trace("Starting the before generate method for " + resource.getURI().toString());
            DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), rs -> new DemandableLock());
            IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
            try {
                lock.getWriteLock(true);
                this.fsaFactory.beforeGenerate(resource);
                RosettaModel model = (RosettaModel)resource.getContents().get(0);
                if (!this.shouldGenerate(model)) {
                    return;
                }
                String version = model.getVersion();
                this.externalGenerators.forEach(generator -> generator.beforeGenerate(resource, model, version, map -> map.forEach((key, value) -> fsa.generateFile(key, generator.getOutputConfiguration().getName(), value)), lock));
            }
            catch (CancellationException e) {
                LOGGER.trace("Code generation cancelled, this is expected");
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected calling before generate for rosetta -{} - see debug logging for more", (Object)e.getMessage());
                LOGGER.debug("Unexpected calling before generate for rosetta", (Throwable)e);
                throw new GenerationException(e.getMessage(), resource.getURI(), null, e.getCause());
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        if (!this.isIgnoredFile(resource)) {
            LOGGER.trace("Starting the main generate method for " + resource.getURI().toString());
            IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, false);
            DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), rs -> new DemandableLock());
            try {
                lock.getWriteLock(true);
                RosettaModel model = (RosettaModel)resource.getContents().get(0);
                if (!this.shouldGenerate(model)) {
                    return;
                }
                String version = model.getVersion();
                List<JavaClassGenerator> javaGenerators = List.of(this.conditionGenerator, this.dataGenerator, this.metaGenerator, this.cardinalityValidatorGenerator, this.typeFormatValidatorGenerator, this.onlyExistsValidatorGenerator, this.deepPathUtilGenerator, this.funcGenerator, this.labelProviderGenerator, this.ruleGenerator, this.reportGenerator, this.enumGenerator, this.metaFieldGenerator);
                List<GenerationException> aggregatedGenerationExceptions = javaGenerators.stream().flatMap(generator -> generator.generateClasses(model, version, fsa2, context.getCancelIndicator()).stream()).collect(Collectors.toList());
                if (!aggregatedGenerationExceptions.isEmpty()) {
                    if (aggregatedGenerationExceptions.size() == 1) {
                        throw (GenerationException)aggregatedGenerationExceptions.get(0);
                    }
                    throw new AggregateGenerationException("Multiple errors encountered during generation", resource.getURI(), aggregatedGenerationExceptions);
                }
                this.externalGenerators.forEach(generator -> generator.generate(resource, model, version, map -> map.forEach((key, value) -> fsa.generateFile(key, generator.getOutputConfiguration().getName(), value)), lock));
            }
            catch (CancellationException e) {
                LOGGER.trace("Code generation cancelled, this is expected");
            }
            catch (AggregateGenerationException | GenerationException e) {
                LOGGER.warn("Unexpected calling standard generate for rosetta root element  -{} - see debug logging for more", (Object)e.getMessage());
                LOGGER.info("Unexpected calling standard generate for rosetta root element", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected calling standard generate for rosetta -{} - see debug logging for more", (Object)e.getMessage());
                LOGGER.info("Unexpected calling standard generate for rosetta", (Throwable)e);
                throw new GenerationException(e.getMessage(), resource.getURI(), null, e.getCause());
            }
            finally {
                LOGGER.trace("ending the main generate method");
                lock.releaseWriteLock();
            }
        }
    }

    public void afterGenerate(Resource resource, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        if (!this.isIgnoredFile(resource)) {
            LOGGER.trace("Starting the after generate method for " + resource.getURI().toString());
            DemandableLock lock = this.locks.computeIfAbsent(resource.getResourceSet(), rs -> new DemandableLock());
            IFileSystemAccess2 fsa = this.fsaFactory.resourceAwareFSA(resource, fsa2, true);
            try {
                lock.getWriteLock(true);
                RosettaModel model = (RosettaModel)resource.getContents().get(0);
                if (!this.shouldGenerate(model)) {
                    return;
                }
                String version = model.getVersion();
                this.externalGenerators.forEach(generator -> generator.afterGenerate(resource, model, version, map -> map.forEach((key, value) -> fsa.generateFile(key, generator.getOutputConfiguration().getName(), value)), lock));
                this.fsaFactory.afterGenerate(resource);
                List<RosettaModel> models = resource.getResourceSet().getResources().stream().filter(r -> !this.isIgnoredFile((Resource)r)).map(r -> (RosettaModel)r.getContents().get(0)).filter(this::shouldGenerate).collect(Collectors.toList());
                this.javaPackageInfoGenerator.generatePackageInfoClasses(fsa2, models);
            }
            catch (CancellationException e) {
                LOGGER.trace("Code generation cancelled, this is expected");
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected calling after generate for rosetta -{} - see debug logging for more", (Object)e.getMessage());
                LOGGER.debug("Unexpected calling after generate for rosetta", (Throwable)e);
                throw new GenerationException(e.getMessage(), resource.getURI(), null, e.getCause());
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }

    public void afterAllGenerate(ResourceSet resourceSet, IFileSystemAccess2 fsa2, IGeneratorContext context) {
        LOGGER.trace("Starting the after all generate method");
        DemandableLock lock = this.locks.computeIfAbsent(resourceSet, rs -> new DemandableLock());
        try {
            lock.getWriteLock(true);
            List models = resourceSet.getResources().stream().filter(r -> !this.isIgnoredFile((Resource)r)).map(r -> (RosettaModel)r.getContents().get(0)).filter(this::shouldGenerate).collect(Collectors.toList());
            String version = models.isEmpty() ? null : ((RosettaModel)models.get(0)).getVersion();
            this.externalGenerators.forEach(generator -> generator.afterAllGenerate(resourceSet, models, version, map -> map.forEach((key, value) -> fsa2.generateFile(key, generator.getOutputConfiguration().getName(), value)), lock));
        }
        catch (CancellationException e) {
            LOGGER.trace("Code generation cancelled, this is expected");
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected calling after all generate for rosetta -{} - see debug logging for more", (Object)e.getMessage());
            LOGGER.debug("Unexpected calling after all generate for rosetta", (Throwable)e);
            throw new GenerationException(e.getMessage(), null, null, e.getCause());
        }
        finally {
            lock.releaseWriteLock();
        }
    }

    private boolean shouldGenerate(RosettaModel model) {
        return this.config.getNamespaceFilter().test(model.getName()) || model.isOverridden();
    }

    private boolean isIgnoredFile(Resource resource) {
        String[] segments = resource.getURI().segments();
        String lastSegment = segments.length > 0 ? segments[segments.length - 1] : null;
        return this.ignoredFiles.contains(lastSegment);
    }
}

