/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types.builtin;

import com.regnosys.rosetta.builtin.RosettaBuiltinsService;
import com.regnosys.rosetta.interpreter.RosettaNumberValue;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RTypeFunction;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.rosetta.model.lib.RosettaNumber;
import com.rosetta.util.DottedPath;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RBuiltinTypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RBuiltinTypeService.class);
    @Inject
    private RosettaBuiltinsService builtinsService;
    private Map<String, Function<Map<String, RosettaValue>, RType>> typeMap = new HashMap<String, Function<Map<String, RosettaValue>, RType>>();
    public final String INT_NAME = "int";
    public final RTypeFunction INT_FUNCTION = new RTypeFunction(DottedPath.splitOnDots((String)"com.rosetta.model"), "int"){

        @Override
        public RNumberType evaluate(Map<String, RosettaValue> arguments) {
            HashMap<String, RosettaValue> numberArgs = new HashMap<String, RosettaValue>(arguments);
            numberArgs.put("fractionalDigits", RosettaNumberValue.of(RosettaNumber.ZERO));
            return RNumberType.from(numberArgs);
        }

        @Override
        public Optional<LinkedHashMap<String, RosettaValue>> reverse(RType type) {
            if (!(type instanceof RNumberType)) {
                return Optional.empty();
            }
            RNumberType nt = (RNumberType)type;
            if (!nt.isInteger() || nt.getScale().isPresent()) {
                return Optional.empty();
            }
            Map<String, RosettaValue> oldArgs = nt.getArguments();
            LinkedHashMap<String, RosettaValue> newArgs = new LinkedHashMap<String, RosettaValue>();
            newArgs.put("digits", oldArgs.get("digits"));
            newArgs.put("min", oldArgs.get("min"));
            newArgs.put("max", oldArgs.get("max"));
            return Optional.of(newArgs);
        }
    };
    public final RBasicType BOOLEAN = this.registerConstantType(new RBasicType("boolean", true));
    public final RMetaAnnotatedType BOOLEAN_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.BOOLEAN);
    public final RBasicType TIME = this.registerConstantType(new RBasicType("time", true));
    public final RMetaAnnotatedType TIME_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.TIME);
    public final RBasicType PATTERN = this.registerConstantType(new RBasicType("pattern", false));
    public final RMetaAnnotatedType PATTERN_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.PATTERN);
    public final RBasicType NOTHING = this.registerConstantType(new RBasicType("nothing", true));
    public final RMetaAnnotatedType NOTHING_WITH_ANY_META = new RMetaAnnotatedType(this.NOTHING, List.of()){

        @Override
        public List<RMetaAttribute> getMetaAttributes() {
            LOGGER.error("getMetaAttributes called on type NOTHING_WITH_ANY_META", (Throwable)new Exception());
            return super.getMetaAttributes();
        }
    };
    public final RBasicType ANY = this.registerConstantType(new RBasicType("any", false));
    public final RMetaAnnotatedType ANY_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.ANY);
    public final RAliasType UNCONSTRAINED_INT = new RAliasType(this.INT_FUNCTION, new LinkedHashMap<String, RosettaValue>(Map.of("digits", RosettaValue.empty(), "min", RosettaValue.empty(), "max", RosettaValue.empty())), new RNumberType(Optional.empty(), Optional.of(0), Optional.empty(), Optional.empty(), Optional.empty()), new ArrayList<Condition>());
    public final RMetaAnnotatedType UNCONSTRAINED_INT_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.UNCONSTRAINED_INT);
    public final RNumberType UNCONSTRAINED_NUMBER = new RNumberType(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public final RMetaAnnotatedType UNCONSTRAINED_NUMBER_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.UNCONSTRAINED_NUMBER);
    public final RStringType UNCONSTRAINED_STRING = new RStringType(Optional.empty(), Optional.empty(), Optional.empty());
    public final RMetaAnnotatedType UNCONSTRAINED_STRING_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.UNCONSTRAINED_STRING);
    public final RDateType DATE = this.registerConstantType(new RDateType());
    public final RMetaAnnotatedType DATE_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.DATE);
    public final RDateTimeType DATE_TIME = this.registerConstantType(new RDateTimeType());
    public final RMetaAnnotatedType DATE_TIME_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.DATE_TIME);
    public final RZonedDateTimeType ZONED_DATE_TIME = this.registerConstantType(new RZonedDateTimeType());
    public final RMetaAnnotatedType ZONED_DATE_TIME_WITH_NO_META = RMetaAnnotatedType.withNoMeta(this.ZONED_DATE_TIME);

    public RBuiltinTypeService() {
        this.register("number", m -> RNumberType.from(m));
        this.register("string", m -> RStringType.from(m));
        this.register("productType", m -> this.UNCONSTRAINED_STRING);
        this.register("eventType", m -> this.UNCONSTRAINED_STRING);
        this.register("calculation", m -> this.UNCONSTRAINED_STRING);
        this.register("int", m -> this.UNCONSTRAINED_INT);
    }

    public Optional<RType> getType(String name, Map<String, RosettaValue> params) {
        return Optional.ofNullable(this.typeMap.get(name)).map(constr -> (RType)constr.apply(params));
    }

    public Optional<RType> getType(RosettaType type, Map<String, RosettaValue> params) {
        return this.getType(type.getName(), params);
    }

    public <T extends RosettaType> T toRosettaType(RType builtinType, Class<T> resultType, ResourceSet resourceSet) {
        RosettaModel basicTypes = this.builtinsService.getBasicTypesModel(resourceSet);
        return (T)basicTypes.getElements().stream().filter(resultType::isInstance).map(resultType::cast).filter(t -> t.getName().equals(builtinType.getName())).findAny().orElseThrow();
    }

    private <T extends RType> T registerConstantType(T t) {
        this.register(t.getName(), m -> t);
        return t;
    }

    private void register(String name, Function<Map<String, RosettaValue>, RType> constructor) {
        if (this.typeMap.put(name, constructor) != null) {
            throw new IllegalStateException("There already exists a builtin type named `" + name + "`.");
        }
    }
}

