/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.regnosys.rosetta.common.serialisation.BeanUtil;
import com.regnosys.rosetta.common.serialisation.ConstantAttributePropertyWriter;
import com.regnosys.rosetta.common.serialisation.mixin.EnumAsStringBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaEnumBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.VirtualXMLAttribute;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.util.DottedPath;
import com.rosetta.util.serialisation.AttributeXMLConfiguration;
import com.rosetta.util.serialisation.AttributeXMLRepresentation;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class RosettaXMLAnnotationIntrospector
extends JacksonXmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final JsonPOJOBuilder.Value ROSETTA_BUILDER_CONFIG = new JsonPOJOBuilder.Value("build", "set");
    private final RosettaXMLConfiguration rosettaXMLConfiguration;
    private final RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector;
    private final EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector;
    private Map<String, TypeConfigEntry> elementIndex = null;
    private Map<String, List<TypeConfigEntry>> substitutionGroupIndex = null;
    private final ObjectMapper mapper;

    public RosettaXMLAnnotationIntrospector(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, boolean supportNativeEnumValue) {
        this(mapper, rosettaXMLConfiguration, new RosettaEnumBuilderIntrospector(supportNativeEnumValue), new EnumAsStringBuilderIntrospector());
    }

    public RosettaXMLAnnotationIntrospector(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector, EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector) {
        this.mapper = mapper;
        this.rosettaXMLConfiguration = rosettaXMLConfiguration;
        this.rosettaEnumBuilderIntrospector = rosettaEnumBuilderIntrospector;
        this.enumAsStringBuilderIntrospector = enumAsStringBuilderIntrospector;
    }

    private void buildSubstitutionLogicIndexes() {
        this.elementIndex = new HashMap<String, TypeConfigEntry>();
        this.substitutionGroupIndex = new HashMap<String, List<TypeConfigEntry>>();
        SortedMap typeConfigMap = this.rosettaXMLConfiguration.getTypeConfigMap();
        for (Map.Entry entry : typeConfigMap.entrySet()) {
            ModelSymbolId symbolId = (ModelSymbolId)entry.getKey();
            TypeXMLConfiguration cfg = (TypeXMLConfiguration)entry.getValue();
            TypeConfigEntry typeConfigEntry = new TypeConfigEntry(symbolId, cfg);
            cfg.getXmlElementFullyQualifiedName().ifPresent(fqn -> {
                if (this.elementIndex.containsKey(fqn)) {
                    throw new IllegalStateException(String.format("Attempted to add duplicate key %s to element index", fqn));
                }
                this.elementIndex.put((String)fqn, typeConfigEntry);
            });
            cfg.getSubstitutionGroup().ifPresent(group -> this.substitutionGroupIndex.computeIfAbsent((String)group, k -> new ArrayList()).add(typeConfigEntry));
        }
    }

    public SubstitutionMap findSubstitutionMap(MapperConfig<?> config, AnnotatedMember member, ClassLoader classLoader) {
        AnnotatedClass ac = this.getAnnotatedClassOrContent(config, member);
        RosettaDataType ann = (RosettaDataType)ac.getAnnotation(RosettaDataType.class);
        if (ann != null) {
            HashMap<JavaType, String> substitutionMap = new HashMap<JavaType, String>();
            this.getAttributeXMLConfiguration(config, (Annotated)member).flatMap(this::getElementRef).ifPresent(elementRef -> {
                this.populateSubstitutionMapForElementByFullyQualifiedName(config, (String)elementRef, (Map<JavaType, String>)substitutionMap, classLoader);
                this.populateSubstitutionMapForTransitiveSubstitutionGroups(config, (String)elementRef, (Map<JavaType, String>)substitutionMap, classLoader);
            });
            this.lookupLegacySubstitutionsForType(config, ac, ann, substitutionMap, classLoader);
            if (substitutionMap.isEmpty()) {
                return null;
            }
            return new SubstitutionMap(substitutionMap);
        }
        return null;
    }

    public Map<String, TypeConfigEntry> getElementIndex() {
        if (this.elementIndex == null) {
            this.buildSubstitutionLogicIndexes();
        }
        return this.elementIndex;
    }

    public Map<String, List<TypeConfigEntry>> getSubstitutionGroupIndex() {
        if (this.substitutionGroupIndex == null) {
            this.buildSubstitutionLogicIndexes();
        }
        return this.substitutionGroupIndex;
    }

    private Optional<String> getElementRef(AttributeXMLConfiguration attributeXMLConfiguration) {
        return attributeXMLConfiguration.getElementRef().isPresent() ? attributeXMLConfiguration.getElementRef() : attributeXMLConfiguration.getSubstitutionGroup();
    }

    private void populateSubstitutionMapForElementByFullyQualifiedName(MapperConfig<?> config, String fullyQualifiedName, Map<JavaType, String> substitutionMap, ClassLoader classLoader) {
        Map<String, TypeConfigEntry> elementIndex = this.getElementIndex();
        if (elementIndex.containsKey(fullyQualifiedName)) {
            TypeConfigEntry entry = elementIndex.get(fullyQualifiedName);
            this.updateSubstitutionMap(config, substitutionMap, classLoader, entry.config, entry.symbolId);
        }
    }

    private void populateSubstitutionMapForTransitiveSubstitutionGroups(MapperConfig<?> config, String substitutionGroup, Map<JavaType, String> substitutionMap, ClassLoader classLoader) {
        this.populateSubstitutionMapForTransitiveSubstitutionGroups(config, substitutionGroup, substitutionMap, classLoader, new HashSet<String>());
    }

    private void populateSubstitutionMapForTransitiveSubstitutionGroups(MapperConfig<?> config, String substitutionGroup, Map<JavaType, String> substitutionMap, ClassLoader classLoader, Set<String> visited) {
        if (!visited.add(substitutionGroup)) {
            return;
        }
        Map<String, List<TypeConfigEntry>> substitutionGroupIndex = this.getSubstitutionGroupIndex();
        for (TypeConfigEntry entry : substitutionGroupIndex.getOrDefault(substitutionGroup, Lists.newArrayList())) {
            this.updateSubstitutionMap(config, substitutionMap, classLoader, entry.config, entry.symbolId);
            entry.config.getXmlElementFullyQualifiedName().ifPresent(fqn -> this.populateSubstitutionMapForTransitiveSubstitutionGroups(config, (String)fqn, substitutionMap, classLoader, visited));
        }
    }

    private void updateSubstitutionMap(MapperConfig<?> config, Map<JavaType, String> substitutionMap, ClassLoader classLoader, TypeXMLConfiguration typeXMLConfiguration, ModelSymbolId key) {
        if (!typeXMLConfiguration.getAbstract().orElse(false).booleanValue()) {
            try {
                JavaType javaType = config.constructType(classLoader.loadClass(key.toString()));
                typeXMLConfiguration.getXmlElementName().ifPresent(name -> substitutionMap.put(javaType, (String)name));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void lookupLegacySubstitutionsForType(MapperConfig<?> config, AnnotatedClass ac, RosettaDataType ann, Map<JavaType, String> substitutionMap, ClassLoader classLoader) {
        ModelSymbolId id = this.createModelSymbolId(ac, ann.value());
        ArrayList substitutions = new ArrayList(this.rosettaXMLConfiguration.getSubstitutionsForType(id));
        if (!substitutions.isEmpty()) {
            substitutionMap.putAll(Streams.concat((Stream[])new Stream[]{substitutions.stream(), Stream.of(id)}).collect(Collectors.toMap(s -> {
                try {
                    return config.constructType(classLoader.loadClass(s.toString()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }, this::getElementName)));
        }
    }

    private String getElementName(ModelSymbolId type) {
        return this.rosettaXMLConfiguration.getConfigurationForType(type).flatMap(TypeXMLConfiguration::getXmlElementName).orElse(type.getName());
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        return this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getDeserializationConfig(), (Annotated)member).flatMap(AttributeXMLConfiguration::getXmlRepresentation).filter(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VIRTUAL).map(repr -> NameTransformer.NOP).orElseGet(() -> super.findUnwrappingNameTransformer(member));
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).builder();
        }
        return super.findPOJOBuilder(ac);
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ROSETTA_BUILDER_CONFIG;
        }
        return super.findPOJOBuilderConfig(ac);
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        return this.getTypeXMLConfigurations((MapperConfig<?>)this.mapper.getSerializationConfig(), ac).stream().filter(t -> t.getXmlElementName().isPresent()).map(t -> (String)t.getXmlElementName().get()).findFirst().map(PropertyName::construct).orElseGet(() -> Optional.ofNullable(super.findRootName(ac)).orElseGet(() -> Optional.ofNullable((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).map(rosettaDataTypeAnn -> PropertyName.construct((String)rosettaDataTypeAnn.value())).orElse(null)));
    }

    protected PropertyName _findXmlName(Annotated a) {
        if (a.getRawType().equals(List.class) && this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getSerializationConfig(), a).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(repr -> repr == AttributeXMLRepresentation.VIRTUAL).orElse(false).booleanValue()) {
            return PropertyName.NO_NAME;
        }
        if (this.shouldUseDefaultPropertyName((MapperConfig<?>)this.mapper.getSerializationConfig(), a)) {
            return PropertyName.USE_DEFAULT;
        }
        return this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getSerializationConfig(), a).flatMap(AttributeXMLConfiguration::getXmlName).map(PropertyName::construct).orElseGet(() -> Optional.ofNullable((RosettaAttribute)a.getAnnotation(RosettaAttribute.class)).map(rosettaAttrAnn -> PropertyName.construct((String)rosettaAttrAnn.value())).orElseGet(() -> super._findXmlName(a)));
    }

    private boolean shouldUseDefaultPropertyName(MapperConfig<?> config, Annotated a) {
        return this.getAttributeXMLConfiguration(config, a).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElse(false);
    }

    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        this.getTypeXMLConfigurations(config, ac).forEach(typeXMLConfiguration -> typeXMLConfiguration.getXmlAttributes().ifPresent(xmlAttributes -> {
            for (String xmlAttributeName : xmlAttributes.keySet()) {
                String xmlAttributeValue = (String)xmlAttributes.get(xmlAttributeName);
                JavaType propType = config.constructType(String.class);
                BeanPropertyWriter bpw = this.constructVirtualXMLAttribute(xmlAttributeName, xmlAttributeValue, config, ac, propType);
                properties.add(bpw);
            }
        }));
        super.findAndAddVirtualProperties(config, ac, properties);
    }

    private BeanPropertyWriter constructVirtualXMLAttribute(String xmlAttributeName, String xmlAttributeValue, MapperConfig<?> config, AnnotatedClass ac, JavaType type) {
        PropertyName propertyName = PropertyName.construct((String)xmlAttributeName);
        VirtualXMLAttribute member = new VirtualXMLAttribute(ac.getRawType(), xmlAttributeName, type);
        SimpleBeanPropertyDefinition xmlPropertyDefinition = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)propertyName, (PropertyMetadata)PropertyMetadata.STD_REQUIRED, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
        return new ConstantAttributePropertyWriter(xmlAttributeName, (BeanPropertyDefinition)xmlPropertyDefinition, ac.getAnnotations(), type, xmlAttributeValue);
    }

    public Boolean isOutputAsAttribute(MapperConfig<?> config, Annotated ann) {
        if (ann instanceof VirtualXMLAttribute) {
            return true;
        }
        return this.getAttributeXMLConfiguration(config, ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.ATTRIBUTE).orElseGet(() -> super.isOutputAsAttribute(config, ann));
    }

    public Boolean isOutputAsText(MapperConfig<?> config, Annotated ann) {
        return this.getAttributeXMLConfiguration(config, ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElseGet(() -> super.isOutputAsText(config, ann));
    }

    protected boolean _isIgnorable(Annotated a) {
        boolean isIgnorable = super._isIgnorable(a);
        if (isIgnorable) {
            return true;
        }
        return a.hasAnnotation(RosettaIgnore.class) && !(a instanceof AnnotatedConstructor) || a.getName().equals("getType");
    }

    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated ac) {
        if (ac instanceof AnnotatedClass && ac.hasAnnotation(RosettaDataType.class)) {
            AnnotatedClass acc = (AnnotatedClass)ac;
            Set<String> includes = this.getPropertyNames(config, acc, x -> x.hasAnnotation(RosettaAttribute.class));
            Set<String> ignored = this.getPropertyNames(config, acc, x -> !x.hasAnnotation(RosettaAttribute.class));
            ignored.removeAll(includes);
            return JsonIgnoreProperties.Value.forIgnoredProperties(ignored).withAllowSetters();
        }
        return super.findPropertyIgnoralByName(config, ac);
    }

    private Set<String> getPropertyNames(MapperConfig<?> config, AnnotatedClass acc, Predicate<AnnotatedMethod> filter) {
        return StreamSupport.stream(acc.memberMethods().spliterator(), false).filter(filter).map(m -> {
            Optional xmlName = this.getAttributeXMLConfiguration(config, (Annotated)m).flatMap(AttributeXMLConfiguration::getXmlName);
            if (xmlName.isPresent()) {
                return (String)xmlName.get();
            }
            RosettaAttribute attr = (RosettaAttribute)m.getAnnotation(RosettaAttribute.class);
            if (attr != null && !attr.value().isEmpty()) {
                return attr.value();
            }
            return BeanUtil.getPropertyName(m.getAnnotated());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public PropertyName findWrapperName(Annotated ann) {
        if (ann.hasAnnotation(RosettaAttribute.class) && this.hasCollectionType(ann)) {
            return PropertyName.NO_NAME;
        }
        return super.findWrapperName(ann);
    }

    private boolean hasCollectionType(Annotated ann) {
        if (ann instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)ann;
            JavaType attributeType = method.getParameterCount() == 1 ? method.getParameterType(0) : method.getType();
            return TypeUtil.isIndexedType((JavaType)attributeType);
        }
        return false;
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        } else {
            this.enumAsStringBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        }
        this.getEnumXMLConfigurations(config, enumType).flatMap(TypeXMLConfiguration::getEnumValues).ifPresent(enumMap -> {
            for (int i = 0; i < enumValues.length; ++i) {
                String nameOverride;
                Field f;
                Enum value = enumValues[i];
                try {
                    f = value.getDeclaringClass().getField(value.name());
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                RosettaEnumValue ann = f.getAnnotation(RosettaEnumValue.class);
                if (ann == null || (nameOverride = (String)enumMap.get(ann.value())) == null) continue;
                names[i] = nameOverride;
            }
        });
        return names;
    }

    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumAliases(enumType, enumValues, aliasList);
        } else {
            super.findEnumAliases(config, enumType, (Enum[])enumValues, aliasList);
        }
    }

    private AnnotatedClass getEnclosingAnnotatedClass(MapperConfig<?> config, AnnotatedMember member) {
        return AnnotatedClassResolver.resolve(config, (JavaType)config.constructType(member.getDeclaringClass()), config);
    }

    private AnnotatedClass getAnnotatedClassOrContent(MapperConfig<?> config, AnnotatedMember m) {
        AnnotatedMethod method;
        JavaType t = m instanceof AnnotatedMethod ? ((method = (AnnotatedMethod)m).getParameterCount() == 1 ? method.getParameterType(0) : method.getType()) : m.getType();
        if (t.getContentType() != null) {
            t = t.getContentType();
        }
        return AnnotatedClassResolver.resolve(config, (JavaType)t, config);
    }

    private Optional<AttributeXMLConfiguration> getAttributeXMLConfiguration(MapperConfig<?> config, Annotated a) {
        return Optional.of(a).filter(annotated -> annotated instanceof AnnotatedMember).map(annotated -> (AnnotatedMember)annotated).flatMap(annotatedMember -> Optional.ofNullable((RosettaAttribute)annotatedMember.getAnnotation(RosettaAttribute.class)).flatMap(rosettaAttributeAnnotation -> this.getTypeXMLConfigurations(config, this.getEnclosingAnnotatedClass(config, (AnnotatedMember)annotatedMember)).stream().filter(t -> t.getAttributes().isPresent()).map(t -> (Map)t.getAttributes().get()).filter(attrMap -> attrMap.containsKey(rosettaAttributeAnnotation.value())).map(attributeMap -> (AttributeXMLConfiguration)attributeMap.get(rosettaAttributeAnnotation.value())).findFirst()));
    }

    private List<TypeXMLConfiguration> getTypeXMLConfigurations(MapperConfig<?> config, AnnotatedClass ac) {
        RosettaDataType ann;
        ArrayList<TypeXMLConfiguration> result = new ArrayList<TypeXMLConfiguration>();
        HashSet<ModelSymbolId> visited = new HashSet<ModelSymbolId>();
        while ((ann = (RosettaDataType)ac.getAnnotation(RosettaDataType.class)) != null) {
            ModelSymbolId modelSymbolId = this.createModelSymbolId(ac, ann.value());
            if (visited.add(modelSymbolId)) {
                this.rosettaXMLConfiguration.getConfigurationForType(modelSymbolId).ifPresent(result::add);
            }
            if (ac.getType().getSuperClass() == null) break;
            ac = AnnotatedClassResolver.resolve(config, (JavaType)ac.getType().getSuperClass(), config);
        }
        return result;
    }

    private Optional<TypeXMLConfiguration> getEnumXMLConfigurations(MapperConfig<?> config, AnnotatedClass ac) {
        RosettaEnum ann = (RosettaEnum)ac.getAnnotation(RosettaEnum.class);
        if (ann != null) {
            ModelSymbolId modelSymbolId = this.createModelSymbolId(ac, ann.value());
            return this.rosettaXMLConfiguration.getConfigurationForType(modelSymbolId);
        }
        return Optional.empty();
    }

    private ModelSymbolId createModelSymbolId(AnnotatedClass ac, String name) {
        String namespace = ac.getType().getRawClass().getPackage().getName();
        return new ModelSymbolId(DottedPath.splitOnDots((String)namespace), name);
    }

    private static class TypeConfigEntry {
        final ModelSymbolId symbolId;
        final TypeXMLConfiguration config;

        TypeConfigEntry(ModelSymbolId symbolId, TypeXMLConfiguration config) {
            this.symbolId = symbolId;
            this.config = config;
        }
    }
}

