/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.deser.XmlBeanDeserializerModifier;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializerModifier;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.common.serialisation.xml.RosettaXMLAnnotationIntrospector;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMapLoader;
import com.regnosys.rosetta.common.serialisation.xml.deserialization.RosettaBeanDeserializerModifier;
import com.regnosys.rosetta.common.serialisation.xml.serialization.RosettaBeanSerializerModifier;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosettaXMLModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RosettaXMLModule.class);
    private final RosettaXMLConfiguration rosettaXMLConfiguration;
    private final boolean supportNativeEnumValue;
    private final ObjectMapper mapper;
    private final ClassLoader classLoader;
    private static final ZoneId UNKNOWN_ZONE;
    private static final List<DateTimeFormatter> DATE_WITH_OFFSET_FORMATTERS;

    public RosettaXMLModule(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, boolean supportNativeEnumValue, ClassLoader classLoader) {
        super(RosettaXMLModule.class.getSimpleName());
        this.mapper = mapper;
        this.rosettaXMLConfiguration = rosettaXMLConfiguration;
        this.supportNativeEnumValue = supportNativeEnumValue;
        this.classLoader = classLoader;
    }

    public void setupModule(Module.SetupContext context) {
        SubstitutionMapLoader substitutionMapLoader = new SubstitutionMapLoader(this.classLoader);
        context.addBeanSerializerModifier((BeanSerializerModifier)new RosettaBeanSerializerModifier(substitutionMapLoader));
        context.addBeanSerializerModifier((BeanSerializerModifier)new XmlBeanSerializerModifier());
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new RosettaBeanDeserializerModifier(substitutionMapLoader));
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new XmlBeanDeserializerModifier(""));
        context.insertAnnotationIntrospector((AnnotationIntrospector)new RosettaXMLAnnotationIntrospector(this.mapper, this.rosettaXMLConfiguration, this.supportNativeEnumValue));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new StdDeserializer<LocalTime>(LocalTime.class){

            public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                String next = (String)p.readValueAs(String.class);
                try {
                    OffsetTime time = OffsetTime.parse(next, DateTimeFormatter.ISO_TIME);
                    return time.toLocalTime().minusSeconds(time.getOffset().getTotalSeconds());
                }
                catch (DateTimeParseException e) {
                    return LocalTime.parse(next, DateTimeFormatter.ISO_TIME);
                }
            }
        });
        this.addSerializer(LocalTime.class, (JsonSerializer)new StdSerializer<LocalTime>(LocalTime.class){

            public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(DateTimeFormatter.ISO_TIME.format(OffsetTime.of(value, ZoneOffset.UTC)));
            }
        });
        this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new StdDeserializer<ZonedDateTime>(ZonedDateTime.class){

            public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                String dateTimeStr = (String)p.readValueAs(String.class);
                try {
                    return ZonedDateTime.parse(dateTimeStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    try {
                        return OffsetDateTime.parse(dateTimeStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toZonedDateTime();
                    }
                    catch (DateTimeParseException dateTimeParseException2) {
                        try {
                            LocalDateTime ldt = LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                            return ldt.atZone(UNKNOWN_ZONE);
                        }
                        catch (DateTimeParseException ldt) {
                            for (DateTimeFormatter formatter : DATE_WITH_OFFSET_FORMATTERS) {
                                try {
                                    TemporalAccessor parsed = formatter.parse(dateTimeStr);
                                    LocalDate date = LocalDate.from(parsed);
                                    ZoneOffset offset = ZoneOffset.from(parsed);
                                    return date.atStartOfDay().atOffset(offset).toZonedDateTime();
                                }
                                catch (DateTimeParseException dateTimeParseException3) {
                                }
                            }
                            try {
                                LocalDate date = LocalDate.parse(dateTimeStr, DateTimeFormatter.ISO_LOCAL_DATE);
                                return date.atStartOfDay(UNKNOWN_ZONE);
                            }
                            catch (DateTimeParseException dateTimeParseException4) {
                                throw new IllegalArgumentException("Unrecognized date/time format: " + dateTimeStr);
                            }
                        }
                    }
                }
            }
        });
        this.addSerializer(ZonedDateTime.class, (JsonSerializer)new StdSerializer<ZonedDateTime>(ZonedDateTime.class){

            public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                if (value.getZone().equals(UNKNOWN_ZONE)) {
                    gen.writeString(value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
                } else {
                    gen.writeString(value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                }
            }
        });
        super.setupModule(context);
    }

    static {
        DATE_WITH_OFFSET_FORMATTERS = Lists.newArrayList((Object[])new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-ddXXX"), DateTimeFormatter.ofPattern("yyyy-MM-ddXX"), DateTimeFormatter.ofPattern("yyyy-MM-ddX")});
        ZoneId unknown = null;
        try {
            unknown = ZoneId.of("Unknown");
        }
        catch (Exception e) {
            LOGGER.error("Failed to create ZoneId for 'Unknown'", (Throwable)e);
        }
        UNKNOWN_ZONE = unknown;
    }
}

