/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.databind.JavaType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SubstitutionMap {
    private final Map<JavaType, String> typeToNameMap = new LinkedHashMap<JavaType, String>();

    public SubstitutionMap(Map<JavaType, String> typeToNameMap) {
        typeToNameMap.keySet().stream().sorted((o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.getRawClass().equals(o2.getRawClass())) {
                return o1.toString().compareTo(o2.toString());
            }
            if (o1.getRawClass().isAssignableFrom(o2.getRawClass())) {
                return 1;
            }
            if (o2.getRawClass().isAssignableFrom(o1.getRawClass())) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }).forEach(key -> this.typeToNameMap.put((JavaType)key, (String)typeToNameMap.get(key)));
    }

    public String getSubstitutedName(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return this.typeToNameMap.entrySet().stream().filter(e -> ((JavaType)e.getKey()).isTypeOrSuperTypeOf(clazz)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public Collection<JavaType> getTypes() {
        return this.typeToNameMap.keySet();
    }

    public String getName(JavaType type) {
        return this.typeToNameMap.get(type);
    }
}

