/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.common.transform.EvaluateFunctionNotFoundException;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FunctionNameHelper {
    public Class<?> getInputClass(Class<? extends RosettaFunction> function) {
        Method functionMethod = this.getFuncMethod(function);
        return functionMethod.getParameterTypes()[0];
    }

    public String getInputType(Class<? extends RosettaFunction> function) {
        return this.getInputClass(function).getName();
    }

    public String getOutputType(Class<? extends RosettaFunction> function) {
        Method functionMethod = this.getFuncMethod(function);
        return functionMethod.getReturnType().getName();
    }

    public Method getFuncMethod(Class<? extends RosettaFunction> function) {
        try {
            List evaluateMethods = Arrays.stream(function.getMethods()).filter(m -> m.getName().equals("evaluate")).filter(m -> !m.isBridge()).filter(m -> !m.isSynthetic()).collect(Collectors.toList());
            return (Method)Iterables.getLast(evaluateMethods);
        }
        catch (Exception ex) {
            throw new EvaluateFunctionNotFoundException("evaluate method not found in " + function.getName(), ex);
        }
    }

    public String getName(Class<? extends RosettaFunction> function) {
        return Optional.ofNullable(function.getAnnotation(RosettaReport.class)).map(a -> String.format("%s / %s", a.body(), String.join((CharSequence)" ", a.corpusList()))).orElse(this.readableFunctionName(function));
    }

    public String getName(Class<? extends RosettaFunction> function, String modelId) {
        return Optional.ofNullable(modelId).map(id -> String.format("%s (%s)", this.getName(function), id)).orElse(this.getName(function));
    }

    public String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public String readableId(Class<? extends RosettaFunction> function) {
        String simpleName = Optional.ofNullable(function.getAnnotation(RosettaReport.class)).map(a -> String.format("%s-%s", a.body(), String.join((CharSequence)"-", a.corpusList()))).orElse(function.getSimpleName());
        return this.readableId(simpleName);
    }

    public String readableFunctionName(String functionSimpleName) {
        return this.readableFunctionNameFromId(this.readableId(functionSimpleName));
    }

    public String readableId(String name) {
        String simpleName = name.replaceAll(".*\\.(.*?)$", "$1");
        String sanitisedName = FunctionNameHelper.getSanitisedName(simpleName).replace("-", ".").replace("_", ".");
        String functionName = this.lowercaseConsecutiveUppercase(sanitisedName).replace(".", "");
        return (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)functionName);
    }

    private static String getSanitisedName(String simpleName) {
        return simpleName.replace("Ingest_", "").replace("Report_", "").replace("ReportFunction", "").replace("Function", "").replace("Enrich_", "").replace("Project_", "");
    }

    private String readableFunctionNameFromId(String readableId) {
        return Arrays.stream(readableId.split("-")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
    }

    private String readableFunctionName(Class<? extends RosettaFunction> function) {
        String readableId = this.readableId(function);
        return this.readableFunctionNameFromId(readableId);
    }

    private String lowercaseConsecutiveUppercase(String input) {
        StringBuilder result = new StringBuilder();
        boolean inUppercaseSequence = false;
        for (int i = 0; i < input.length(); ++i) {
            boolean isLastChar;
            char currentChar;
            char newChar = currentChar = input.charAt(i);
            boolean bl = isLastChar = i == input.length() - 1;
            if (Character.isUpperCase(currentChar)) {
                if (!inUppercaseSequence) {
                    inUppercaseSequence = true;
                } else if (isLastChar || Character.isUpperCase(input.charAt(i + 1)) || input.charAt(i + 1) == '.') {
                    newChar = Character.toLowerCase(currentChar);
                } else {
                    inUppercaseSequence = false;
                }
            } else {
                inUppercaseSequence = false;
            }
            result.append(newChar);
        }
        return result.toString();
    }
}

