/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateSequences;
import com.opengamma.strata.basics.date.LocalDateUtils;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import java.time.YearMonth;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface DateSequence
extends Named {
    @FromString
    public static DateSequence of(String uniqueName) {
        return (DateSequence)DateSequence.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<DateSequence> extendedEnum() {
        return DateSequences.ENUM_LOOKUP;
    }

    default public LocalDate next(LocalDate date) {
        LocalDate next = LocalDateUtils.plusDays(date, 1);
        return this.nextOrSame(next);
    }

    public LocalDate nextOrSame(LocalDate var1);

    default public LocalDate nth(LocalDate date, int sequenceNumber) {
        ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
        if (sequenceNumber == 1) {
            return this.next(date);
        }
        return this.nth(this.next(date), sequenceNumber - 1);
    }

    default public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
        ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
        if (sequenceNumber == 1) {
            return this.nextOrSame(date);
        }
        return this.nth(this.nextOrSame(date), sequenceNumber - 1);
    }

    public LocalDate dateMatching(YearMonth var1);

    @ToString
    public String getName();
}

