/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.base.math.functions.RoundToPrecisionRemoveTrailingZeros;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

public class RoundToPrecisionRemoveTrailingDecimalZerosImpl
extends RoundToPrecisionRemoveTrailingZeros {
    @Inject
    private RoundToPrecision roundToPrecision;

    protected BigDecimal doEvaluate(BigDecimal value, Integer precision, RoundingDirectionEnum roundingMode) {
        return Optional.ofNullable(this.roundToPrecision.evaluate(value, precision, roundingMode)).map(this::stripTrailingZeros).orElse(null);
    }

    private BigDecimal stripTrailingZeros(BigDecimal roundedValue) {
        String numberStr = roundedValue.toPlainString();
        if (numberStr.contains(".") && (numberStr = numberStr.replaceAll("0+$", "")).endsWith(".")) {
            numberStr = numberStr.substring(0, numberStr.length() - 1);
        }
        return new BigDecimal(numberStr);
    }
}

