/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.drr.utils.gleif;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import drr.enrichment.lei.LeiCategoryEnum;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.LeiRegistrationStatusEnum;
import drr.enrichment.lei.LeiStatusEnum;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GleifLeiAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GleifLeiAdaptor.class);

    public LeiData adapt(String responseJson) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode node = objectMapper.readTree(responseJson);
            return LeiData.builder().setLei(GleifLeiAdaptor.extractField(node, "/data/attributes/lei").orElse(null)).setEntityName(GleifLeiAdaptor.extractField(node, "/data/attributes/entity/legalName/name").orElse(null)).setEntityCategory(GleifLeiAdaptor.extractField(node, "/data/attributes/entity/category").map(GleifLeiAdaptor::toLeiCategoryEnum).orElse(null)).setEntityStatus(GleifLeiAdaptor.extractField(node, "/data/attributes/entity/status").map(GleifLeiAdaptor::toLeiStatusEnum).orElse(LeiStatusEnum.NULL)).setBranchEntityStatus(GleifLeiAdaptor.extractField(node, "/data/attributes/branches/entityStatus").map(GleifLeiAdaptor::toLeiStatusEnum).orElse(LeiStatusEnum.NULL)).setRegistrationStatus(GleifLeiAdaptor.extractField(node, "/data/attributes/registration/status").map(GleifLeiAdaptor::toLeiRegistrationStatusEnum).orElse(null)).setRegistrationDate(GleifLeiAdaptor.extractField(node, "/data/attributes/registration/initialRegistrationDate").map(GleifLeiAdaptor::parseZonedDateTime).orElse(null)).setPublished(GleifLeiAdaptor.isPublished(node)).build();
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error occurred parsing JSON response: {}", (Object)responseJson, (Object)e);
            return null;
        }
    }

    private static Optional<String> extractField(JsonNode node, String path) {
        return Optional.ofNullable(node.at(path)).map(JsonNode::asText).filter(str -> !str.isEmpty());
    }

    private static LeiCategoryEnum toLeiCategoryEnum(String entityCategory) {
        try {
            return LeiCategoryEnum.valueOf(entityCategory);
        }
        catch (Exception e) {
            LOGGER.warn("Unknown LEI entity category received from GLEIF {}", (Object)entityCategory);
            return null;
        }
    }

    private static LeiStatusEnum toLeiStatusEnum(String leiStatus) {
        try {
            return LeiStatusEnum.valueOf(leiStatus);
        }
        catch (Exception e) {
            LOGGER.warn("Unknown LEI status received from GLEIF {}", (Object)leiStatus);
            return null;
        }
    }

    private static LeiRegistrationStatusEnum toLeiRegistrationStatusEnum(String registrationStatus) {
        try {
            return LeiRegistrationStatusEnum.valueOf(registrationStatus);
        }
        catch (Exception e) {
            LOGGER.warn("Unknown LEI registration status received from GLEIF {}", (Object)registrationStatus);
            return null;
        }
    }

    private static ZonedDateTime parseZonedDateTime(String zonedDateTime) {
        return ZonedDateTime.parse(zonedDateTime);
    }

    private static boolean isPublished(JsonNode node) {
        return GleifLeiAdaptor.extractField(node, "/data/type").map("lei-records"::equals).orElse(false) != false && GleifLeiAdaptor.extractField(node, "/data/id").isPresent() && GleifLeiAdaptor.extractField(node, "/data/links/self").isPresent();
    }
}

