/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;

@ImplementedBy(value=GetFctvDtDefault.class)
public abstract class GetFctvDt
implements RosettaFunction {
    public Date evaluate(ESMAEMIRTransactionReport drrReport) {
        Date fctvDt = this.doEvaluate(drrReport);
        return fctvDt;
    }

    protected abstract Date doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetFctvDtDefault
    extends GetFctvDt {
        @Override
        protected Date doEvaluate(ESMAEMIRTransactionReport drrReport) {
            Date fctvDt = null;
            return this.assignOutput(fctvDt, drrReport);
        }

        protected Date assignOutput(Date fctvDt, ESMAEMIRTransactionReport drrReport) {
            fctvDt = (Date)MapperS.of((Object)drrReport).map("getEffectiveDate", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getEffectiveDate()).get();
            return fctvDt;
        }
    }
}

