/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.price.functions.Contract_Price_Monetary;
import javax.inject.Inject;

@ImplementedBy(value=PriceUnitOfMeasureRuleDefault.class)
public abstract class PriceUnitOfMeasureRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Contract_Price_Monetary contract_Price_Monetary;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.PriceUnitOfMeasureRule priceUnitOfMeasureRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PriceUnitOfMeasureRuleDefault
    extends PriceUnitOfMeasureRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of(this.contract_Price_Monetary.evaluate((ReportableEvent)item.get())).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperC.of(this.contract_Price_Monetary.evaluate((ReportableEvent)item.get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.PERCENTAGE_OF_NOTIONAL), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.areEqual((Mapper)MapperC.of(this.contract_Price_Monetary.evaluate((ReportableEvent)item.get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.ABSOLUTE_TERMS), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"ACCY");
                }
                return MapperS.of((Object)this.priceUnitOfMeasureRule.evaluate((TransactionReportInstruction)item.get()));
            }).get();
            return output;
        }
    }
}

