/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version2.price.reports.StrikePriceNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceNotationRuleDefault.class)
public abstract class StrikePriceNotationRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected DefaultPercentageToDecimal defaultPercentageToDecimal;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected StrikePriceNotationEnumRule strikePriceNotationEnumRule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceNotationRuleDefault
    extends StrikePriceNotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            output = (PriceNotationEnum)((Object)MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.strikePriceNotationEnumRule.evaluate((TransactionReportInstruction)thenArg.get()), false))).get());
            return output;
        }
    }
}

