/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CommonAssetClass")
public enum CommonAssetClass {
    INTR("INTR", null),
    CRDT("CRDT", null),
    EQUI("EQUI", null),
    COMM("COMM", null),
    CURR("CURR", null);

    private static Map<String, CommonAssetClass> values;
    private final String rosettaName;
    private final String displayName;

    private CommonAssetClass(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CommonAssetClass fromDisplayName(String name) {
        CommonAssetClass value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CommonAssetClass> map = new ConcurrentHashMap<String, CommonAssetClass>();
        for (CommonAssetClass instance : CommonAssetClass.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

