/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.ASICPartyInformation;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.CSAPartyInformation;
import drr.regulation.common.ClearingException;
import drr.regulation.common.ESMAPartyInformation;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.HKMAPartyInformation;
import drr.regulation.common.MandatorilyClearableEnum;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportingRoleEnum;
import drr.regulation.common.SECPartyInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TechnicalRecordId;
import drr.regulation.common.meta.ReportingRegimeMeta;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReportingRegime", builder=ReportingRegimeBuilderImpl.class, version="6.19.3")
@RuneDataType(value="ReportingRegime", model="drr", builder=ReportingRegimeBuilderImpl.class, version="6.19.3")
public interface ReportingRegime
extends RosettaModelObject {
    public static final ReportingRegimeMeta metaData = new ReportingRegimeMeta();

    public FieldWithMetaRegimeNameEnum getRegimeName();

    public FieldWithMetaSupervisoryBodyEnum getSupervisoryBody();

    public MandatorilyClearableEnum getMandatorilyClearable();

    public ClearingException getClearingException();

    public Boolean getPostPricedIndicator();

    public ASICPartyInformation getAsicPartyInformation();

    public CFTCPartyInformation getCftcPartyInformation();

    public CSAPartyInformation getCsaPartyInformation();

    public HKMAPartyInformation getHkmaPartyInformation();

    public ESMAPartyInformation getEsmaPartyInformation();

    public FCAPartyInformation getFcaPartyInformation();

    public SECPartyInformation getSecPartyInformation();

    public ReportingRoleEnum getReportingRole();

    public ReportingRoleEnum getTradingCapacity();

    public TechnicalRecordId getTechnicalRecordId();

    public ReportingRegime build();

    public ReportingRegimeBuilder toBuilder();

    public static ReportingRegimeBuilder builder() {
        return new ReportingRegimeBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportingRegime> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportingRegime> getType() {
        return ReportingRegime.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("regimeName"), processor, FieldWithMetaRegimeNameEnum.class, this.getRegimeName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("supervisoryBody"), processor, FieldWithMetaSupervisoryBodyEnum.class, this.getSupervisoryBody(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mandatorilyClearable"), MandatorilyClearableEnum.class, (Object)this.getMandatorilyClearable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingException"), processor, ClearingException.class, this.getClearingException(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postPricedIndicator"), Boolean.class, (Object)this.getPostPricedIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asicPartyInformation"), processor, ASICPartyInformation.class, this.getAsicPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cftcPartyInformation"), processor, CFTCPartyInformation.class, this.getCftcPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("csaPartyInformation"), processor, CSAPartyInformation.class, this.getCsaPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("hkmaPartyInformation"), processor, HKMAPartyInformation.class, this.getHkmaPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esmaPartyInformation"), processor, ESMAPartyInformation.class, this.getEsmaPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fcaPartyInformation"), processor, FCAPartyInformation.class, this.getFcaPartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secPartyInformation"), processor, SECPartyInformation.class, this.getSecPartyInformation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingRole"), ReportingRoleEnum.class, (Object)this.getReportingRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), ReportingRoleEnum.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("technicalRecordId"), processor, TechnicalRecordId.class, this.getTechnicalRecordId(), new AttributeMeta[0]);
    }

    public static class ReportingRegimeBuilderImpl
    implements ReportingRegimeBuilder {
        protected FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder regimeName;
        protected FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder supervisoryBody;
        protected MandatorilyClearableEnum mandatorilyClearable;
        protected ClearingException.ClearingExceptionBuilder clearingException;
        protected Boolean postPricedIndicator;
        protected ASICPartyInformation.ASICPartyInformationBuilder asicPartyInformation;
        protected CFTCPartyInformation.CFTCPartyInformationBuilder cftcPartyInformation;
        protected CSAPartyInformation.CSAPartyInformationBuilder csaPartyInformation;
        protected HKMAPartyInformation.HKMAPartyInformationBuilder hkmaPartyInformation;
        protected ESMAPartyInformation.ESMAPartyInformationBuilder esmaPartyInformation;
        protected FCAPartyInformation.FCAPartyInformationBuilder fcaPartyInformation;
        protected SECPartyInformation.SECPartyInformationBuilder secPartyInformation;
        protected ReportingRoleEnum reportingRole;
        protected ReportingRoleEnum tradingCapacity;
        protected TechnicalRecordId.TechnicalRecordIdBuilder technicalRecordId;

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder getRegimeName() {
            return this.regimeName;
        }

        @Override
        public FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder getOrCreateRegimeName() {
            FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder result = this.regimeName != null ? this.regimeName : (this.regimeName = FieldWithMetaRegimeNameEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        public FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder getOrCreateSupervisoryBody() {
            FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder result = this.supervisoryBody != null ? this.supervisoryBody : (this.supervisoryBody = FieldWithMetaSupervisoryBodyEnum.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public MandatorilyClearableEnum getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="clearingException")
        @RuneAttribute(value="clearingException")
        public ClearingException.ClearingExceptionBuilder getClearingException() {
            return this.clearingException;
        }

        @Override
        public ClearingException.ClearingExceptionBuilder getOrCreateClearingException() {
            ClearingException.ClearingExceptionBuilder result = this.clearingException != null ? this.clearingException : (this.clearingException = ClearingException.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public Boolean getPostPricedIndicator() {
            return this.postPricedIndicator;
        }

        @Override
        @RosettaAttribute(value="asicPartyInformation")
        @RuneAttribute(value="asicPartyInformation")
        public ASICPartyInformation.ASICPartyInformationBuilder getAsicPartyInformation() {
            return this.asicPartyInformation;
        }

        @Override
        public ASICPartyInformation.ASICPartyInformationBuilder getOrCreateAsicPartyInformation() {
            ASICPartyInformation.ASICPartyInformationBuilder result = this.asicPartyInformation != null ? this.asicPartyInformation : (this.asicPartyInformation = ASICPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cftcPartyInformation")
        @RuneAttribute(value="cftcPartyInformation")
        public CFTCPartyInformation.CFTCPartyInformationBuilder getCftcPartyInformation() {
            return this.cftcPartyInformation;
        }

        @Override
        public CFTCPartyInformation.CFTCPartyInformationBuilder getOrCreateCftcPartyInformation() {
            CFTCPartyInformation.CFTCPartyInformationBuilder result = this.cftcPartyInformation != null ? this.cftcPartyInformation : (this.cftcPartyInformation = CFTCPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="csaPartyInformation")
        @RuneAttribute(value="csaPartyInformation")
        public CSAPartyInformation.CSAPartyInformationBuilder getCsaPartyInformation() {
            return this.csaPartyInformation;
        }

        @Override
        public CSAPartyInformation.CSAPartyInformationBuilder getOrCreateCsaPartyInformation() {
            CSAPartyInformation.CSAPartyInformationBuilder result = this.csaPartyInformation != null ? this.csaPartyInformation : (this.csaPartyInformation = CSAPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="hkmaPartyInformation")
        @RuneAttribute(value="hkmaPartyInformation")
        public HKMAPartyInformation.HKMAPartyInformationBuilder getHkmaPartyInformation() {
            return this.hkmaPartyInformation;
        }

        @Override
        public HKMAPartyInformation.HKMAPartyInformationBuilder getOrCreateHkmaPartyInformation() {
            HKMAPartyInformation.HKMAPartyInformationBuilder result = this.hkmaPartyInformation != null ? this.hkmaPartyInformation : (this.hkmaPartyInformation = HKMAPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esmaPartyInformation")
        @RuneAttribute(value="esmaPartyInformation")
        public ESMAPartyInformation.ESMAPartyInformationBuilder getEsmaPartyInformation() {
            return this.esmaPartyInformation;
        }

        @Override
        public ESMAPartyInformation.ESMAPartyInformationBuilder getOrCreateEsmaPartyInformation() {
            ESMAPartyInformation.ESMAPartyInformationBuilder result = this.esmaPartyInformation != null ? this.esmaPartyInformation : (this.esmaPartyInformation = ESMAPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fcaPartyInformation")
        @RuneAttribute(value="fcaPartyInformation")
        public FCAPartyInformation.FCAPartyInformationBuilder getFcaPartyInformation() {
            return this.fcaPartyInformation;
        }

        @Override
        public FCAPartyInformation.FCAPartyInformationBuilder getOrCreateFcaPartyInformation() {
            FCAPartyInformation.FCAPartyInformationBuilder result = this.fcaPartyInformation != null ? this.fcaPartyInformation : (this.fcaPartyInformation = FCAPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secPartyInformation")
        @RuneAttribute(value="secPartyInformation")
        public SECPartyInformation.SECPartyInformationBuilder getSecPartyInformation() {
            return this.secPartyInformation;
        }

        @Override
        public SECPartyInformation.SECPartyInformationBuilder getOrCreateSecPartyInformation() {
            SECPartyInformation.SECPartyInformationBuilder result = this.secPartyInformation != null ? this.secPartyInformation : (this.secPartyInformation = SECPartyInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRoleEnum getReportingRole() {
            return this.reportingRole;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public ReportingRoleEnum getTradingCapacity() {
            return this.tradingCapacity;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public TechnicalRecordId.TechnicalRecordIdBuilder getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        public TechnicalRecordId.TechnicalRecordIdBuilder getOrCreateTechnicalRecordId() {
            TechnicalRecordId.TechnicalRecordIdBuilder result = this.technicalRecordId != null ? this.technicalRecordId : (this.technicalRecordId = TechnicalRecordId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public ReportingRegimeBuilder setRegimeName(FieldWithMetaRegimeNameEnum _regimeName) {
            this.regimeName = _regimeName == null ? null : _regimeName.toBuilder();
            return this;
        }

        @Override
        public ReportingRegimeBuilder setRegimeNameValue(RegimeNameEnum _regimeName) {
            this.getOrCreateRegimeName().setValue(_regimeName);
            return this;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public ReportingRegimeBuilder setSupervisoryBody(FieldWithMetaSupervisoryBodyEnum _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody.toBuilder();
            return this;
        }

        @Override
        public ReportingRegimeBuilder setSupervisoryBodyValue(SupervisoryBodyEnum _supervisoryBody) {
            this.getOrCreateSupervisoryBody().setValue(_supervisoryBody);
            return this;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public ReportingRegimeBuilder setMandatorilyClearable(MandatorilyClearableEnum _mandatorilyClearable) {
            this.mandatorilyClearable = _mandatorilyClearable == null ? null : _mandatorilyClearable;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingException")
        @RuneAttribute(value="clearingException")
        public ReportingRegimeBuilder setClearingException(ClearingException _clearingException) {
            this.clearingException = _clearingException == null ? null : _clearingException.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public ReportingRegimeBuilder setPostPricedIndicator(Boolean _postPricedIndicator) {
            this.postPricedIndicator = _postPricedIndicator == null ? null : _postPricedIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="asicPartyInformation")
        @RuneAttribute(value="asicPartyInformation")
        public ReportingRegimeBuilder setAsicPartyInformation(ASICPartyInformation _asicPartyInformation) {
            this.asicPartyInformation = _asicPartyInformation == null ? null : _asicPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cftcPartyInformation")
        @RuneAttribute(value="cftcPartyInformation")
        public ReportingRegimeBuilder setCftcPartyInformation(CFTCPartyInformation _cftcPartyInformation) {
            this.cftcPartyInformation = _cftcPartyInformation == null ? null : _cftcPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="csaPartyInformation")
        @RuneAttribute(value="csaPartyInformation")
        public ReportingRegimeBuilder setCsaPartyInformation(CSAPartyInformation _csaPartyInformation) {
            this.csaPartyInformation = _csaPartyInformation == null ? null : _csaPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="hkmaPartyInformation")
        @RuneAttribute(value="hkmaPartyInformation")
        public ReportingRegimeBuilder setHkmaPartyInformation(HKMAPartyInformation _hkmaPartyInformation) {
            this.hkmaPartyInformation = _hkmaPartyInformation == null ? null : _hkmaPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esmaPartyInformation")
        @RuneAttribute(value="esmaPartyInformation")
        public ReportingRegimeBuilder setEsmaPartyInformation(ESMAPartyInformation _esmaPartyInformation) {
            this.esmaPartyInformation = _esmaPartyInformation == null ? null : _esmaPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fcaPartyInformation")
        @RuneAttribute(value="fcaPartyInformation")
        public ReportingRegimeBuilder setFcaPartyInformation(FCAPartyInformation _fcaPartyInformation) {
            this.fcaPartyInformation = _fcaPartyInformation == null ? null : _fcaPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secPartyInformation")
        @RuneAttribute(value="secPartyInformation")
        public ReportingRegimeBuilder setSecPartyInformation(SECPartyInformation _secPartyInformation) {
            this.secPartyInformation = _secPartyInformation == null ? null : _secPartyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRegimeBuilder setReportingRole(ReportingRoleEnum _reportingRole) {
            this.reportingRole = _reportingRole == null ? null : _reportingRole;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public ReportingRegimeBuilder setTradingCapacity(ReportingRoleEnum _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public ReportingRegimeBuilder setTechnicalRecordId(TechnicalRecordId _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId.toBuilder();
            return this;
        }

        @Override
        public ReportingRegime build() {
            return new ReportingRegimeImpl(this);
        }

        @Override
        public ReportingRegimeBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportingRegimeBuilder prune() {
            if (this.regimeName != null && !this.regimeName.prune().hasData()) {
                this.regimeName = null;
            }
            if (this.supervisoryBody != null && !this.supervisoryBody.prune().hasData()) {
                this.supervisoryBody = null;
            }
            if (this.clearingException != null && !this.clearingException.prune().hasData()) {
                this.clearingException = null;
            }
            if (this.asicPartyInformation != null && !this.asicPartyInformation.prune().hasData()) {
                this.asicPartyInformation = null;
            }
            if (this.cftcPartyInformation != null && !this.cftcPartyInformation.prune().hasData()) {
                this.cftcPartyInformation = null;
            }
            if (this.csaPartyInformation != null && !this.csaPartyInformation.prune().hasData()) {
                this.csaPartyInformation = null;
            }
            if (this.hkmaPartyInformation != null && !this.hkmaPartyInformation.prune().hasData()) {
                this.hkmaPartyInformation = null;
            }
            if (this.esmaPartyInformation != null && !this.esmaPartyInformation.prune().hasData()) {
                this.esmaPartyInformation = null;
            }
            if (this.fcaPartyInformation != null && !this.fcaPartyInformation.prune().hasData()) {
                this.fcaPartyInformation = null;
            }
            if (this.secPartyInformation != null && !this.secPartyInformation.prune().hasData()) {
                this.secPartyInformation = null;
            }
            if (this.technicalRecordId != null && !this.technicalRecordId.prune().hasData()) {
                this.technicalRecordId = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRegimeName() != null) {
                return true;
            }
            if (this.getSupervisoryBody() != null) {
                return true;
            }
            if (this.getMandatorilyClearable() != null) {
                return true;
            }
            if (this.getClearingException() != null && this.getClearingException().hasData()) {
                return true;
            }
            if (this.getPostPricedIndicator() != null) {
                return true;
            }
            if (this.getAsicPartyInformation() != null && this.getAsicPartyInformation().hasData()) {
                return true;
            }
            if (this.getCftcPartyInformation() != null && this.getCftcPartyInformation().hasData()) {
                return true;
            }
            if (this.getCsaPartyInformation() != null && this.getCsaPartyInformation().hasData()) {
                return true;
            }
            if (this.getHkmaPartyInformation() != null && this.getHkmaPartyInformation().hasData()) {
                return true;
            }
            if (this.getEsmaPartyInformation() != null && this.getEsmaPartyInformation().hasData()) {
                return true;
            }
            if (this.getFcaPartyInformation() != null && this.getFcaPartyInformation().hasData()) {
                return true;
            }
            if (this.getSecPartyInformation() != null && this.getSecPartyInformation().hasData()) {
                return true;
            }
            if (this.getReportingRole() != null) {
                return true;
            }
            if (this.getTradingCapacity() != null) {
                return true;
            }
            return this.getTechnicalRecordId() != null && this.getTechnicalRecordId().hasData();
        }

        public ReportingRegimeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportingRegimeBuilder o = (ReportingRegimeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegimeName(), (RosettaModelObjectBuilder)o.getRegimeName(), this::setRegimeName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSupervisoryBody(), (RosettaModelObjectBuilder)o.getSupervisoryBody(), this::setSupervisoryBody);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingException(), (RosettaModelObjectBuilder)o.getClearingException(), this::setClearingException);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsicPartyInformation(), (RosettaModelObjectBuilder)o.getAsicPartyInformation(), this::setAsicPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCftcPartyInformation(), (RosettaModelObjectBuilder)o.getCftcPartyInformation(), this::setCftcPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCsaPartyInformation(), (RosettaModelObjectBuilder)o.getCsaPartyInformation(), this::setCsaPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getHkmaPartyInformation(), (RosettaModelObjectBuilder)o.getHkmaPartyInformation(), this::setHkmaPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsmaPartyInformation(), (RosettaModelObjectBuilder)o.getEsmaPartyInformation(), this::setEsmaPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFcaPartyInformation(), (RosettaModelObjectBuilder)o.getFcaPartyInformation(), this::setFcaPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecPartyInformation(), (RosettaModelObjectBuilder)o.getSecPartyInformation(), this::setSecPartyInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)o.getTechnicalRecordId(), this::setTechnicalRecordId);
            merger.mergeBasic((Object)this.getMandatorilyClearable(), (Object)o.getMandatorilyClearable(), this::setMandatorilyClearable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostPricedIndicator(), (Object)o.getPostPricedIndicator(), this::setPostPricedIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingRole(), (Object)o.getReportingRole(), this::setReportingRole, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradingCapacity(), (Object)o.getTradingCapacity(), this::setTradingCapacity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingRegime _that = this.getType().cast(o);
            if (!Objects.equals(this.regimeName, _that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals((Object)this.mandatorilyClearable, (Object)_that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.clearingException, _that.getClearingException())) {
                return false;
            }
            if (!Objects.equals(this.postPricedIndicator, _that.getPostPricedIndicator())) {
                return false;
            }
            if (!Objects.equals(this.asicPartyInformation, _that.getAsicPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.cftcPartyInformation, _that.getCftcPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.csaPartyInformation, _that.getCsaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.hkmaPartyInformation, _that.getHkmaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.esmaPartyInformation, _that.getEsmaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.fcaPartyInformation, _that.getFcaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.secPartyInformation, _that.getSecPartyInformation())) {
                return false;
            }
            if (!Objects.equals((Object)this.reportingRole, (Object)_that.getReportingRole())) {
                return false;
            }
            if (!Objects.equals((Object)this.tradingCapacity, (Object)_that.getTradingCapacity())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? this.regimeName.hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? ((Object)((Object)this.mandatorilyClearable)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingException != null ? this.clearingException.hashCode() : 0);
            _result = 31 * _result + (this.postPricedIndicator != null ? this.postPricedIndicator.hashCode() : 0);
            _result = 31 * _result + (this.asicPartyInformation != null ? this.asicPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.cftcPartyInformation != null ? this.cftcPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.csaPartyInformation != null ? this.csaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.hkmaPartyInformation != null ? this.hkmaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.esmaPartyInformation != null ? this.esmaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.fcaPartyInformation != null ? this.fcaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.secPartyInformation != null ? this.secPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? ((Object)((Object)this.reportingRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradingCapacity != null ? ((Object)((Object)this.tradingCapacity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingRegimeBuilder {regimeName=" + String.valueOf(this.regimeName) + ", supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", mandatorilyClearable=" + String.valueOf((Object)this.mandatorilyClearable) + ", clearingException=" + String.valueOf(this.clearingException) + ", postPricedIndicator=" + this.postPricedIndicator + ", asicPartyInformation=" + String.valueOf(this.asicPartyInformation) + ", cftcPartyInformation=" + String.valueOf(this.cftcPartyInformation) + ", csaPartyInformation=" + String.valueOf(this.csaPartyInformation) + ", hkmaPartyInformation=" + String.valueOf(this.hkmaPartyInformation) + ", esmaPartyInformation=" + String.valueOf(this.esmaPartyInformation) + ", fcaPartyInformation=" + String.valueOf(this.fcaPartyInformation) + ", secPartyInformation=" + String.valueOf(this.secPartyInformation) + ", reportingRole=" + String.valueOf((Object)this.reportingRole) + ", tradingCapacity=" + String.valueOf((Object)this.tradingCapacity) + ", technicalRecordId=" + String.valueOf(this.technicalRecordId) + "}";
        }
    }

    public static interface ReportingRegimeBuilder
    extends ReportingRegime,
    RosettaModelObjectBuilder {
        public FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder getOrCreateRegimeName();

        @Override
        public FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder getRegimeName();

        public FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder getOrCreateSupervisoryBody();

        @Override
        public FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder getSupervisoryBody();

        public ClearingException.ClearingExceptionBuilder getOrCreateClearingException();

        @Override
        public ClearingException.ClearingExceptionBuilder getClearingException();

        public ASICPartyInformation.ASICPartyInformationBuilder getOrCreateAsicPartyInformation();

        @Override
        public ASICPartyInformation.ASICPartyInformationBuilder getAsicPartyInformation();

        public CFTCPartyInformation.CFTCPartyInformationBuilder getOrCreateCftcPartyInformation();

        @Override
        public CFTCPartyInformation.CFTCPartyInformationBuilder getCftcPartyInformation();

        public CSAPartyInformation.CSAPartyInformationBuilder getOrCreateCsaPartyInformation();

        @Override
        public CSAPartyInformation.CSAPartyInformationBuilder getCsaPartyInformation();

        public HKMAPartyInformation.HKMAPartyInformationBuilder getOrCreateHkmaPartyInformation();

        @Override
        public HKMAPartyInformation.HKMAPartyInformationBuilder getHkmaPartyInformation();

        public ESMAPartyInformation.ESMAPartyInformationBuilder getOrCreateEsmaPartyInformation();

        @Override
        public ESMAPartyInformation.ESMAPartyInformationBuilder getEsmaPartyInformation();

        public FCAPartyInformation.FCAPartyInformationBuilder getOrCreateFcaPartyInformation();

        @Override
        public FCAPartyInformation.FCAPartyInformationBuilder getFcaPartyInformation();

        public SECPartyInformation.SECPartyInformationBuilder getOrCreateSecPartyInformation();

        @Override
        public SECPartyInformation.SECPartyInformationBuilder getSecPartyInformation();

        public TechnicalRecordId.TechnicalRecordIdBuilder getOrCreateTechnicalRecordId();

        @Override
        public TechnicalRecordId.TechnicalRecordIdBuilder getTechnicalRecordId();

        public ReportingRegimeBuilder setRegimeName(FieldWithMetaRegimeNameEnum var1);

        public ReportingRegimeBuilder setRegimeNameValue(RegimeNameEnum var1);

        public ReportingRegimeBuilder setSupervisoryBody(FieldWithMetaSupervisoryBodyEnum var1);

        public ReportingRegimeBuilder setSupervisoryBodyValue(SupervisoryBodyEnum var1);

        public ReportingRegimeBuilder setMandatorilyClearable(MandatorilyClearableEnum var1);

        public ReportingRegimeBuilder setClearingException(ClearingException var1);

        public ReportingRegimeBuilder setPostPricedIndicator(Boolean var1);

        public ReportingRegimeBuilder setAsicPartyInformation(ASICPartyInformation var1);

        public ReportingRegimeBuilder setCftcPartyInformation(CFTCPartyInformation var1);

        public ReportingRegimeBuilder setCsaPartyInformation(CSAPartyInformation var1);

        public ReportingRegimeBuilder setHkmaPartyInformation(HKMAPartyInformation var1);

        public ReportingRegimeBuilder setEsmaPartyInformation(ESMAPartyInformation var1);

        public ReportingRegimeBuilder setFcaPartyInformation(FCAPartyInformation var1);

        public ReportingRegimeBuilder setSecPartyInformation(SECPartyInformation var1);

        public ReportingRegimeBuilder setReportingRole(ReportingRoleEnum var1);

        public ReportingRegimeBuilder setTradingCapacity(ReportingRoleEnum var1);

        public ReportingRegimeBuilder setTechnicalRecordId(TechnicalRecordId var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("regimeName"), processor, FieldWithMetaRegimeNameEnum.FieldWithMetaRegimeNameEnumBuilder.class, this.getRegimeName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("supervisoryBody"), processor, FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder.class, this.getSupervisoryBody(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mandatorilyClearable"), MandatorilyClearableEnum.class, (Object)this.getMandatorilyClearable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingException"), processor, ClearingException.ClearingExceptionBuilder.class, this.getClearingException(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postPricedIndicator"), Boolean.class, (Object)this.getPostPricedIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asicPartyInformation"), processor, ASICPartyInformation.ASICPartyInformationBuilder.class, this.getAsicPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cftcPartyInformation"), processor, CFTCPartyInformation.CFTCPartyInformationBuilder.class, this.getCftcPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("csaPartyInformation"), processor, CSAPartyInformation.CSAPartyInformationBuilder.class, this.getCsaPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("hkmaPartyInformation"), processor, HKMAPartyInformation.HKMAPartyInformationBuilder.class, this.getHkmaPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esmaPartyInformation"), processor, ESMAPartyInformation.ESMAPartyInformationBuilder.class, this.getEsmaPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fcaPartyInformation"), processor, FCAPartyInformation.FCAPartyInformationBuilder.class, this.getFcaPartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secPartyInformation"), processor, SECPartyInformation.SECPartyInformationBuilder.class, this.getSecPartyInformation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingRole"), ReportingRoleEnum.class, (Object)this.getReportingRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), ReportingRoleEnum.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("technicalRecordId"), processor, TechnicalRecordId.TechnicalRecordIdBuilder.class, this.getTechnicalRecordId(), new AttributeMeta[0]);
        }

        public ReportingRegimeBuilder prune();
    }

    public static class ReportingRegimeImpl
    implements ReportingRegime {
        private final FieldWithMetaRegimeNameEnum regimeName;
        private final FieldWithMetaSupervisoryBodyEnum supervisoryBody;
        private final MandatorilyClearableEnum mandatorilyClearable;
        private final ClearingException clearingException;
        private final Boolean postPricedIndicator;
        private final ASICPartyInformation asicPartyInformation;
        private final CFTCPartyInformation cftcPartyInformation;
        private final CSAPartyInformation csaPartyInformation;
        private final HKMAPartyInformation hkmaPartyInformation;
        private final ESMAPartyInformation esmaPartyInformation;
        private final FCAPartyInformation fcaPartyInformation;
        private final SECPartyInformation secPartyInformation;
        private final ReportingRoleEnum reportingRole;
        private final ReportingRoleEnum tradingCapacity;
        private final TechnicalRecordId technicalRecordId;

        protected ReportingRegimeImpl(ReportingRegimeBuilder builder) {
            this.regimeName = Optional.ofNullable(builder.getRegimeName()).map(f -> f.build()).orElse(null);
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).map(f -> f.build()).orElse(null);
            this.mandatorilyClearable = builder.getMandatorilyClearable();
            this.clearingException = Optional.ofNullable(builder.getClearingException()).map(f -> f.build()).orElse(null);
            this.postPricedIndicator = builder.getPostPricedIndicator();
            this.asicPartyInformation = Optional.ofNullable(builder.getAsicPartyInformation()).map(f -> f.build()).orElse(null);
            this.cftcPartyInformation = Optional.ofNullable(builder.getCftcPartyInformation()).map(f -> f.build()).orElse(null);
            this.csaPartyInformation = Optional.ofNullable(builder.getCsaPartyInformation()).map(f -> f.build()).orElse(null);
            this.hkmaPartyInformation = Optional.ofNullable(builder.getHkmaPartyInformation()).map(f -> f.build()).orElse(null);
            this.esmaPartyInformation = Optional.ofNullable(builder.getEsmaPartyInformation()).map(f -> f.build()).orElse(null);
            this.fcaPartyInformation = Optional.ofNullable(builder.getFcaPartyInformation()).map(f -> f.build()).orElse(null);
            this.secPartyInformation = Optional.ofNullable(builder.getSecPartyInformation()).map(f -> f.build()).orElse(null);
            this.reportingRole = builder.getReportingRole();
            this.tradingCapacity = builder.getTradingCapacity();
            this.technicalRecordId = Optional.ofNullable(builder.getTechnicalRecordId()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeName", isRequired=true)
        @RuneAttribute(value="regimeName", isRequired=true)
        public FieldWithMetaRegimeNameEnum getRegimeName() {
            return this.regimeName;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public FieldWithMetaSupervisoryBodyEnum getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public MandatorilyClearableEnum getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="clearingException")
        @RuneAttribute(value="clearingException")
        public ClearingException getClearingException() {
            return this.clearingException;
        }

        @Override
        @RosettaAttribute(value="postPricedIndicator")
        @RuneAttribute(value="postPricedIndicator")
        public Boolean getPostPricedIndicator() {
            return this.postPricedIndicator;
        }

        @Override
        @RosettaAttribute(value="asicPartyInformation")
        @RuneAttribute(value="asicPartyInformation")
        public ASICPartyInformation getAsicPartyInformation() {
            return this.asicPartyInformation;
        }

        @Override
        @RosettaAttribute(value="cftcPartyInformation")
        @RuneAttribute(value="cftcPartyInformation")
        public CFTCPartyInformation getCftcPartyInformation() {
            return this.cftcPartyInformation;
        }

        @Override
        @RosettaAttribute(value="csaPartyInformation")
        @RuneAttribute(value="csaPartyInformation")
        public CSAPartyInformation getCsaPartyInformation() {
            return this.csaPartyInformation;
        }

        @Override
        @RosettaAttribute(value="hkmaPartyInformation")
        @RuneAttribute(value="hkmaPartyInformation")
        public HKMAPartyInformation getHkmaPartyInformation() {
            return this.hkmaPartyInformation;
        }

        @Override
        @RosettaAttribute(value="esmaPartyInformation")
        @RuneAttribute(value="esmaPartyInformation")
        public ESMAPartyInformation getEsmaPartyInformation() {
            return this.esmaPartyInformation;
        }

        @Override
        @RosettaAttribute(value="fcaPartyInformation")
        @RuneAttribute(value="fcaPartyInformation")
        public FCAPartyInformation getFcaPartyInformation() {
            return this.fcaPartyInformation;
        }

        @Override
        @RosettaAttribute(value="secPartyInformation")
        @RuneAttribute(value="secPartyInformation")
        public SECPartyInformation getSecPartyInformation() {
            return this.secPartyInformation;
        }

        @Override
        @RosettaAttribute(value="reportingRole")
        @RuneAttribute(value="reportingRole")
        public ReportingRoleEnum getReportingRole() {
            return this.reportingRole;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public ReportingRoleEnum getTradingCapacity() {
            return this.tradingCapacity;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public TechnicalRecordId getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        public ReportingRegime build() {
            return this;
        }

        @Override
        public ReportingRegimeBuilder toBuilder() {
            ReportingRegimeBuilder builder = ReportingRegime.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportingRegimeBuilder builder) {
            Optional.ofNullable(this.getRegimeName()).ifPresent(builder::setRegimeName);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getMandatorilyClearable()).ifPresent(builder::setMandatorilyClearable);
            Optional.ofNullable(this.getClearingException()).ifPresent(builder::setClearingException);
            Optional.ofNullable(this.getPostPricedIndicator()).ifPresent(builder::setPostPricedIndicator);
            Optional.ofNullable(this.getAsicPartyInformation()).ifPresent(builder::setAsicPartyInformation);
            Optional.ofNullable(this.getCftcPartyInformation()).ifPresent(builder::setCftcPartyInformation);
            Optional.ofNullable(this.getCsaPartyInformation()).ifPresent(builder::setCsaPartyInformation);
            Optional.ofNullable(this.getHkmaPartyInformation()).ifPresent(builder::setHkmaPartyInformation);
            Optional.ofNullable(this.getEsmaPartyInformation()).ifPresent(builder::setEsmaPartyInformation);
            Optional.ofNullable(this.getFcaPartyInformation()).ifPresent(builder::setFcaPartyInformation);
            Optional.ofNullable(this.getSecPartyInformation()).ifPresent(builder::setSecPartyInformation);
            Optional.ofNullable(this.getReportingRole()).ifPresent(builder::setReportingRole);
            Optional.ofNullable(this.getTradingCapacity()).ifPresent(builder::setTradingCapacity);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportingRegime _that = this.getType().cast(o);
            if (!Objects.equals(this.regimeName, _that.getRegimeName())) {
                return false;
            }
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals((Object)this.mandatorilyClearable, (Object)_that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.clearingException, _that.getClearingException())) {
                return false;
            }
            if (!Objects.equals(this.postPricedIndicator, _that.getPostPricedIndicator())) {
                return false;
            }
            if (!Objects.equals(this.asicPartyInformation, _that.getAsicPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.cftcPartyInformation, _that.getCftcPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.csaPartyInformation, _that.getCsaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.hkmaPartyInformation, _that.getHkmaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.esmaPartyInformation, _that.getEsmaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.fcaPartyInformation, _that.getFcaPartyInformation())) {
                return false;
            }
            if (!Objects.equals(this.secPartyInformation, _that.getSecPartyInformation())) {
                return false;
            }
            if (!Objects.equals((Object)this.reportingRole, (Object)_that.getReportingRole())) {
                return false;
            }
            if (!Objects.equals((Object)this.tradingCapacity, (Object)_that.getTradingCapacity())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regimeName != null ? this.regimeName.hashCode() : 0);
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? ((Object)((Object)this.mandatorilyClearable)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingException != null ? this.clearingException.hashCode() : 0);
            _result = 31 * _result + (this.postPricedIndicator != null ? this.postPricedIndicator.hashCode() : 0);
            _result = 31 * _result + (this.asicPartyInformation != null ? this.asicPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.cftcPartyInformation != null ? this.cftcPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.csaPartyInformation != null ? this.csaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.hkmaPartyInformation != null ? this.hkmaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.esmaPartyInformation != null ? this.esmaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.fcaPartyInformation != null ? this.fcaPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.secPartyInformation != null ? this.secPartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.reportingRole != null ? ((Object)((Object)this.reportingRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradingCapacity != null ? ((Object)((Object)this.tradingCapacity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportingRegime {regimeName=" + String.valueOf(this.regimeName) + ", supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", mandatorilyClearable=" + String.valueOf((Object)this.mandatorilyClearable) + ", clearingException=" + String.valueOf(this.clearingException) + ", postPricedIndicator=" + this.postPricedIndicator + ", asicPartyInformation=" + String.valueOf(this.asicPartyInformation) + ", cftcPartyInformation=" + String.valueOf(this.cftcPartyInformation) + ", csaPartyInformation=" + String.valueOf(this.csaPartyInformation) + ", hkmaPartyInformation=" + String.valueOf(this.hkmaPartyInformation) + ", esmaPartyInformation=" + String.valueOf(this.esmaPartyInformation) + ", fcaPartyInformation=" + String.valueOf(this.fcaPartyInformation) + ", secPartyInformation=" + String.valueOf(this.secPartyInformation) + ", reportingRole=" + String.valueOf((Object)this.reportingRole) + ", tradingCapacity=" + String.valueOf((Object)this.tradingCapacity) + ", technicalRecordId=" + String.valueOf(this.technicalRecordId) + "}";
        }
    }
}

