/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option_Cash;
import cdm.product.qualification.functions.Qualify_Commodity_Option_Physical;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.qualification.functions.Qualify_ForeignExchange_VanillaOption;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.SettlementTermsLeg1;
import drr.regulation.common.functions.SettlementTermsLeg2;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iso.DeliveryTypeEnum;
import javax.inject.Inject;

@ImplementedBy(value=DeliveryTypeForProductsDefault.class)
public abstract class DeliveryTypeForProducts
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option_Cash qualify_Commodity_Option_Cash;
    @Inject
    protected Qualify_Commodity_Option_Physical qualify_Commodity_Option_Physical;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
    @Inject
    protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
    @Inject
    protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
    @Inject
    protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;
    @Inject
    protected Qualify_ForeignExchange_VanillaOption qualify_ForeignExchange_VanillaOption;
    @Inject
    protected SettlementTermsLeg1 settlementTermsLeg1;
    @Inject
    protected SettlementTermsLeg2 settlementTermsLeg2;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public DeliveryTypeEnum evaluate(Product product) {
        DeliveryTypeEnum deliveryType = this.doEvaluate(product);
        return deliveryType;
    }

    protected abstract DeliveryTypeEnum doEvaluate(Product var1);

    protected abstract MapperS<? extends SettlementTerms> settlementLeg(Product var1);

    protected abstract MapperS<DeliveryTypeEnum> deliveryTypeFromSettlementLeg(Product var1);

    public static class DeliveryTypeForProductsDefault
    extends DeliveryTypeForProducts {
        @Override
        protected DeliveryTypeEnum doEvaluate(Product product) {
            DeliveryTypeEnum deliveryType = null;
            return this.assignOutput(deliveryType, product);
        }

        protected DeliveryTypeEnum assignOutput(DeliveryTypeEnum deliveryType, Product product) {
            Boolean boolean4;
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            deliveryType = ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)DeliveryTypeEnum.CASH)), MapperS.of((Object)((Object)DeliveryTypeEnum.PHYS)), MapperS.of((Object)((Object)DeliveryTypeEnum.OPTL))}), this.deliveryTypeFromSettlementLeg(product), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (DeliveryTypeEnum)((Object)this.deliveryTypeFromSettlementLeg(product).get()) : ((boolean0 = this.qualify_AssetClass_InterestRate.evaluate(this.economicTermsForProduct.evaluate(product))) != null && boolean0.booleanValue() ? DeliveryTypeEnum.PHYS : ((boolean1 = this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(product))) != null && boolean1.booleanValue() ? (ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate(product))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate(product)))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)product).map("getIndex", _product -> _product.getIndex()).mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getIndex", _product -> _product.getIndex()).mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.EQUITY), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? DeliveryTypeEnum.CASH : null) : ((boolean2 = this.qualify_AssetClass_Credit.evaluate(this.economicTermsForProduct.evaluate(product))) != null && boolean2.booleanValue() ? DeliveryTypeEnum.OPTL : ((boolean3 = this.qualify_AssetClass_ForeignExchange.evaluate(this.economicTermsForProduct.evaluate(product))) != null && boolean3.booleanValue() ? (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDF.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_NDS.evaluate(this.economicTermsForProduct.evaluate(product))))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? DeliveryTypeEnum.CASH : (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Swap.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_Spot_Forward.evaluate(this.economicTermsForProduct.evaluate(product))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_ForeignExchange_VanillaOption.evaluate(this.economicTermsForProduct.evaluate(product))))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? DeliveryTypeEnum.PHYS : null)) : ((boolean4 = this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(product))) != null && boolean4.booleanValue() ? (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(product))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Option_Cash.evaluate(this.economicTermsForProduct.evaluate(product))))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? DeliveryTypeEnum.CASH : (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate(product)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Option_Physical.evaluate(this.economicTermsForProduct.evaluate(product))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate(product))))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? DeliveryTypeEnum.PHYS : null)) : null)))));
            return deliveryType;
        }

        @Override
        protected MapperS<? extends SettlementTerms> settlementLeg(Product product) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.settlementTermsLeg1.evaluate(product))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.settlementTermsLeg1.evaluate(product));
            }
            return MapperS.of((Object)this.settlementTermsLeg2.evaluate(product));
        }

        @Override
        protected MapperS<DeliveryTypeEnum> deliveryTypeFromSettlementLeg(Product product) {
            if (ExpressionOperators.areEqual((Mapper)this.settlementLeg(product).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)this.settlementLeg(product).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)DeliveryTypeEnum.CASH));
            }
            if (ExpressionOperators.areEqual((Mapper)this.settlementLeg(product).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.PHYSICAL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)this.settlementLeg(product).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)DeliveryTypeEnum.PHYS));
            }
            if (ExpressionOperators.areEqual((Mapper)this.settlementLeg(product).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH_OR_PHYSICAL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)this.settlementLeg(product).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.ELECTION), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)DeliveryTypeEnum.OPTL));
            }
            return MapperS.ofNull();
        }
    }
}

