/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsCommodityForward_SingleIndexDefault.class)
public abstract class IsCommodityForward_SingleIndex
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Product var1);

    protected abstract MapperS<? extends Product> forwardUnderlier(Product var1);

    public static class IsCommodityForward_SingleIndexDefault
    extends IsCommodityForward_SingleIndex {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier = (ReferenceWithMetaProductIdentifier)this.forwardUnderlier(product).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).get();
            result = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_Commodity_Forward.evaluate((EconomicTerms)this.economicTerms(product).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((ForwardPayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)(referenceWithMetaProductIdentifier == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaProductIdentifier.getValue())).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISDACRP), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)this.forwardUnderlier(product).map("getIndex", _product -> _product.getIndex()).mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.COMMODITY), (CardinalityOperator)CardinalityOperator.Any))).get();
            return result;
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product));
        }

        @Override
        protected MapperS<? extends Product> forwardUnderlier(Product product) {
            return MapperS.of((Object)((ForwardPayout)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier());
        }
    }
}

