/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_UnderlierProduct_Equity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsEquityDefault.class)
public abstract class IsEquity
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected Qualify_UnderlierProduct_Equity qualify_UnderlierProduct_Equity;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsEquityDefault
    extends IsEquity {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_UnderlierProduct_Equity.evaluate((Product)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.qualify_UnderlierProduct_Equity.evaluate((Product)MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_UnderlierProduct_Equity.evaluate((Product)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).get())))).get();
            return result;
        }
    }
}

