/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.TradeStateForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=TradeForEventDefault.class)
public abstract class TradeForEvent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected TradeStateForEvent tradeStateForEvent;

    public Trade evaluate(ReportableEvent reportableEvent) {
        Trade reportableTrade;
        Trade.TradeBuilder reportableTradeBuilder = this.doEvaluate(reportableEvent);
        if (reportableTradeBuilder == null) {
            reportableTrade = null;
        } else {
            reportableTrade = reportableTradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)reportableTrade);
        }
        return reportableTrade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(ReportableEvent var1);

    public static class TradeForEventDefault
    extends TradeForEvent {
        @Override
        protected Trade.TradeBuilder doEvaluate(ReportableEvent reportableEvent) {
            Trade.TradeBuilder reportableTrade = Trade.builder();
            return this.assignOutput(reportableTrade, reportableEvent);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder reportableTrade, ReportableEvent reportableEvent) {
            reportableTrade = (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.tradeStateForEvent.evaluate(reportableEvent)).map("getTrade", tradeState -> tradeState.getTrade()).get());
            return Optional.ofNullable(reportableTrade).map(o -> o.prune()).orElse(null);
        }
    }
}

