/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.processor;

import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import drr.regulation.common.ReportableInformation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoBasedMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoBasedMappingProcessor.class);
    public static final String CRYPTO_SCHEME = "http://www.fpml.org/coding-scheme/esma-emir-refit-crypto-asset-indicator";

    public CryptoBasedMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path xmlPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        Boolean cryptoBased = this.determineCrypto(xmlPath);
        if (cryptoBased != null) {
            ReportableInformation.ReportableInformationBuilder reportableInformationBuilder = (ReportableInformation.ReportableInformationBuilder)parent;
            reportableInformationBuilder.setCryptoBased(cryptoBased);
        }
    }

    private Boolean determineCrypto(Path xmlPath) {
        Boolean cryptoBased = this.isCryptoBasedByProductType(xmlPath);
        if (cryptoBased != null) {
            return cryptoBased;
        }
        return null;
    }

    private Boolean isCryptoBasedByProductType(Path xmlPath) {
        List productTypePaths = this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(new String[]{"productType"})).map(Mapping::getXmlPath).collect(Collectors.toList());
        for (Path productTypePath : productTypePaths) {
            String productTypeScheme;
            Path.PathElement schemeElement;
            Optional mappedValue = MappingProcessorUtils.getNonNullMappedValue((Path)productTypePath, (List)this.getMappings());
            if (!mappedValue.isPresent()) continue;
            if (((String)mappedValue.get()).equals("true")) {
                schemeElement = productTypePath.getElements().stream().filter(element -> element.getMetas().containsKey("productTypeScheme")).findFirst().orElse(null);
                if (schemeElement != null) {
                    productTypeScheme = (String)schemeElement.getMetas().get("productTypeScheme");
                    if (!CRYPTO_SCHEME.equals(productTypeScheme)) continue;
                    return true;
                }
                return null;
            }
            if (!((String)mappedValue.get()).equals("false") || (schemeElement = (Path.PathElement)productTypePath.getElements().stream().filter(element -> element.getMetas().containsKey("productTypeScheme")).findFirst().orElse(null)) == null || !CRYPTO_SCHEME.equals(productTypeScheme = (String)schemeElement.getMetas().get("productTypeScheme"))) continue;
            return false;
        }
        return null;
    }
}

