/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.upi.AnnaDsbUpiRequestAndType;
import drr.regulation.common.trade.meta.NonReportableMeta;
import drr.standards.iosco.upi.AnnaDsbDeliveryTypeEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbNotionalScheduleEnum;
import drr.standards.iosco.upi.AnnaDsbUpiRecord;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="NonReportable", builder=NonReportableBuilderImpl.class, version="6.19.3")
@RuneDataType(value="NonReportable", model="drr", builder=NonReportableBuilderImpl.class, version="6.19.3")
public interface NonReportable
extends RosettaModelObject {
    public static final NonReportableMeta metaData = new NonReportableMeta();

    public EnrichmentData getEnrichment();

    public AnnaDsbUpiRequestAndType getPreUpiData();

    public AnnaDsbUpiRecord getPostUpiData();

    public AnnaDsbNotionalScheduleEnum getNotionalSchedule();

    public String getUnderlyingAssetType();

    public AnnaDsbInstrumentTypeEnum getInstrumentType();

    public AnnaDsbDeliveryTypeEnum getDeliveryType();

    public NonReportable build();

    public NonReportableBuilder toBuilder();

    public static NonReportableBuilder builder() {
        return new NonReportableBuilderImpl();
    }

    default public RosettaMetaData<? extends NonReportable> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends NonReportable> getType() {
        return NonReportable.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, this.getEnrichment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.class, this.getPreUpiData(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.class, this.getPostUpiData(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalSchedule"), AnnaDsbNotionalScheduleEnum.class, (Object)this.getNotionalSchedule(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetType"), String.class, (Object)this.getUnderlyingAssetType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("instrumentType"), AnnaDsbInstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), AnnaDsbDeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class NonReportableBuilderImpl
    implements NonReportableBuilder {
        protected EnrichmentData.EnrichmentDataBuilder enrichment;
        protected AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder preUpiData;
        protected AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder postUpiData;
        protected AnnaDsbNotionalScheduleEnum notionalSchedule;
        protected String underlyingAssetType;
        protected AnnaDsbInstrumentTypeEnum instrumentType;
        protected AnnaDsbDeliveryTypeEnum deliveryType;

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
            return this.enrichment;
        }

        @Override
        public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
            EnrichmentData.EnrichmentDataBuilder result = this.enrichment != null ? this.enrichment : (this.enrichment = EnrichmentData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="preUpiData")
        @RuneAttribute(value="preUpiData")
        public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData() {
            return this.preUpiData;
        }

        @Override
        public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData() {
            AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder result = this.preUpiData != null ? this.preUpiData : (this.preUpiData = AnnaDsbUpiRequestAndType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postUpiData")
        @RuneAttribute(value="postUpiData")
        public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData() {
            return this.postUpiData;
        }

        @Override
        public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData() {
            AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder result = this.postUpiData != null ? this.postUpiData : (this.postUpiData = AnnaDsbUpiRecord.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public AnnaDsbNotionalScheduleEnum getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetType")
        @RuneAttribute(value="underlyingAssetType")
        public String getUnderlyingAssetType() {
            return this.underlyingAssetType;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public AnnaDsbInstrumentTypeEnum getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public AnnaDsbDeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public NonReportableBuilder setEnrichment(EnrichmentData _enrichment) {
            this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="preUpiData")
        @RuneAttribute(value="preUpiData")
        public NonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType _preUpiData) {
            this.preUpiData = _preUpiData == null ? null : _preUpiData.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postUpiData")
        @RuneAttribute(value="postUpiData")
        public NonReportableBuilder setPostUpiData(AnnaDsbUpiRecord _postUpiData) {
            this.postUpiData = _postUpiData == null ? null : _postUpiData.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public NonReportableBuilder setNotionalSchedule(AnnaDsbNotionalScheduleEnum _notionalSchedule) {
            this.notionalSchedule = _notionalSchedule == null ? null : _notionalSchedule;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetType")
        @RuneAttribute(value="underlyingAssetType")
        public NonReportableBuilder setUnderlyingAssetType(String _underlyingAssetType) {
            this.underlyingAssetType = _underlyingAssetType == null ? null : _underlyingAssetType;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public NonReportableBuilder setInstrumentType(AnnaDsbInstrumentTypeEnum _instrumentType) {
            this.instrumentType = _instrumentType == null ? null : _instrumentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public NonReportableBuilder setDeliveryType(AnnaDsbDeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        public NonReportable build() {
            return new NonReportableImpl(this);
        }

        @Override
        public NonReportableBuilder toBuilder() {
            return this;
        }

        @Override
        public NonReportableBuilder prune() {
            if (this.enrichment != null && !this.enrichment.prune().hasData()) {
                this.enrichment = null;
            }
            if (this.preUpiData != null && !this.preUpiData.prune().hasData()) {
                this.preUpiData = null;
            }
            if (this.postUpiData != null && !this.postUpiData.prune().hasData()) {
                this.postUpiData = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEnrichment() != null && this.getEnrichment().hasData()) {
                return true;
            }
            if (this.getPreUpiData() != null && this.getPreUpiData().hasData()) {
                return true;
            }
            if (this.getPostUpiData() != null && this.getPostUpiData().hasData()) {
                return true;
            }
            if (this.getNotionalSchedule() != null) {
                return true;
            }
            if (this.getUnderlyingAssetType() != null) {
                return true;
            }
            if (this.getInstrumentType() != null) {
                return true;
            }
            return this.getDeliveryType() != null;
        }

        public NonReportableBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            NonReportableBuilder o = (NonReportableBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEnrichment(), (RosettaModelObjectBuilder)o.getEnrichment(), this::setEnrichment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPreUpiData(), (RosettaModelObjectBuilder)o.getPreUpiData(), this::setPreUpiData);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPostUpiData(), (RosettaModelObjectBuilder)o.getPostUpiData(), this::setPostUpiData);
            merger.mergeBasic((Object)this.getNotionalSchedule(), (Object)o.getNotionalSchedule(), this::setNotionalSchedule, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetType(), (Object)o.getUnderlyingAssetType(), this::setUnderlyingAssetType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInstrumentType(), (Object)o.getInstrumentType(), this::setInstrumentType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonReportable _that = this.getType().cast(o);
            if (!Objects.equals(this.enrichment, _that.getEnrichment())) {
                return false;
            }
            if (!Objects.equals(this.preUpiData, _that.getPreUpiData())) {
                return false;
            }
            if (!Objects.equals(this.postUpiData, _that.getPostUpiData())) {
                return false;
            }
            if (!Objects.equals((Object)this.notionalSchedule, (Object)_that.getNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetType, _that.getUnderlyingAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.instrumentType, (Object)_that.getInstrumentType())) {
                return false;
            }
            return Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.enrichment != null ? this.enrichment.hashCode() : 0);
            _result = 31 * _result + (this.preUpiData != null ? this.preUpiData.hashCode() : 0);
            _result = 31 * _result + (this.postUpiData != null ? this.postUpiData.hashCode() : 0);
            _result = 31 * _result + (this.notionalSchedule != null ? ((Object)((Object)this.notionalSchedule)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetType != null ? this.underlyingAssetType.hashCode() : 0);
            _result = 31 * _result + (this.instrumentType != null ? ((Object)((Object)this.instrumentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonReportableBuilder {enrichment=" + String.valueOf(this.enrichment) + ", preUpiData=" + String.valueOf(this.preUpiData) + ", postUpiData=" + String.valueOf(this.postUpiData) + ", notionalSchedule=" + String.valueOf((Object)this.notionalSchedule) + ", underlyingAssetType=" + this.underlyingAssetType + ", instrumentType=" + String.valueOf((Object)this.instrumentType) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + "}";
        }
    }

    public static interface NonReportableBuilder
    extends NonReportable,
    RosettaModelObjectBuilder {
        public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();

        @Override
        public EnrichmentData.EnrichmentDataBuilder getEnrichment();

        public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getOrCreatePreUpiData();

        @Override
        public AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder getPreUpiData();

        public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getOrCreatePostUpiData();

        @Override
        public AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder getPostUpiData();

        public NonReportableBuilder setEnrichment(EnrichmentData var1);

        public NonReportableBuilder setPreUpiData(AnnaDsbUpiRequestAndType var1);

        public NonReportableBuilder setPostUpiData(AnnaDsbUpiRecord var1);

        public NonReportableBuilder setNotionalSchedule(AnnaDsbNotionalScheduleEnum var1);

        public NonReportableBuilder setUnderlyingAssetType(String var1);

        public NonReportableBuilder setInstrumentType(AnnaDsbInstrumentTypeEnum var1);

        public NonReportableBuilder setDeliveryType(AnnaDsbDeliveryTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, this.getEnrichment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("preUpiData"), processor, AnnaDsbUpiRequestAndType.AnnaDsbUpiRequestAndTypeBuilder.class, this.getPreUpiData(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("postUpiData"), processor, AnnaDsbUpiRecord.AnnaDsbUpiRecordBuilder.class, this.getPostUpiData(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalSchedule"), AnnaDsbNotionalScheduleEnum.class, (Object)this.getNotionalSchedule(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetType"), String.class, (Object)this.getUnderlyingAssetType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("instrumentType"), AnnaDsbInstrumentTypeEnum.class, (Object)this.getInstrumentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), AnnaDsbDeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public NonReportableBuilder prune();
    }

    public static class NonReportableImpl
    implements NonReportable {
        private final EnrichmentData enrichment;
        private final AnnaDsbUpiRequestAndType preUpiData;
        private final AnnaDsbUpiRecord postUpiData;
        private final AnnaDsbNotionalScheduleEnum notionalSchedule;
        private final String underlyingAssetType;
        private final AnnaDsbInstrumentTypeEnum instrumentType;
        private final AnnaDsbDeliveryTypeEnum deliveryType;

        protected NonReportableImpl(NonReportableBuilder builder) {
            this.enrichment = Optional.ofNullable(builder.getEnrichment()).map(f -> f.build()).orElse(null);
            this.preUpiData = Optional.ofNullable(builder.getPreUpiData()).map(f -> f.build()).orElse(null);
            this.postUpiData = Optional.ofNullable(builder.getPostUpiData()).map(f -> f.build()).orElse(null);
            this.notionalSchedule = builder.getNotionalSchedule();
            this.underlyingAssetType = builder.getUnderlyingAssetType();
            this.instrumentType = builder.getInstrumentType();
            this.deliveryType = builder.getDeliveryType();
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public EnrichmentData getEnrichment() {
            return this.enrichment;
        }

        @Override
        @RosettaAttribute(value="preUpiData")
        @RuneAttribute(value="preUpiData")
        public AnnaDsbUpiRequestAndType getPreUpiData() {
            return this.preUpiData;
        }

        @Override
        @RosettaAttribute(value="postUpiData")
        @RuneAttribute(value="postUpiData")
        public AnnaDsbUpiRecord getPostUpiData() {
            return this.postUpiData;
        }

        @Override
        @RosettaAttribute(value="notionalSchedule")
        @RuneAttribute(value="notionalSchedule")
        public AnnaDsbNotionalScheduleEnum getNotionalSchedule() {
            return this.notionalSchedule;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetType")
        @RuneAttribute(value="underlyingAssetType")
        public String getUnderlyingAssetType() {
            return this.underlyingAssetType;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public AnnaDsbInstrumentTypeEnum getInstrumentType() {
            return this.instrumentType;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public AnnaDsbDeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        public NonReportable build() {
            return this;
        }

        @Override
        public NonReportableBuilder toBuilder() {
            NonReportableBuilder builder = NonReportable.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(NonReportableBuilder builder) {
            Optional.ofNullable(this.getEnrichment()).ifPresent(builder::setEnrichment);
            Optional.ofNullable(this.getPreUpiData()).ifPresent(builder::setPreUpiData);
            Optional.ofNullable(this.getPostUpiData()).ifPresent(builder::setPostUpiData);
            Optional.ofNullable(this.getNotionalSchedule()).ifPresent(builder::setNotionalSchedule);
            Optional.ofNullable(this.getUnderlyingAssetType()).ifPresent(builder::setUnderlyingAssetType);
            Optional.ofNullable(this.getInstrumentType()).ifPresent(builder::setInstrumentType);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            NonReportable _that = this.getType().cast(o);
            if (!Objects.equals(this.enrichment, _that.getEnrichment())) {
                return false;
            }
            if (!Objects.equals(this.preUpiData, _that.getPreUpiData())) {
                return false;
            }
            if (!Objects.equals(this.postUpiData, _that.getPostUpiData())) {
                return false;
            }
            if (!Objects.equals((Object)this.notionalSchedule, (Object)_that.getNotionalSchedule())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetType, _that.getUnderlyingAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.instrumentType, (Object)_that.getInstrumentType())) {
                return false;
            }
            return Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.enrichment != null ? this.enrichment.hashCode() : 0);
            _result = 31 * _result + (this.preUpiData != null ? this.preUpiData.hashCode() : 0);
            _result = 31 * _result + (this.postUpiData != null ? this.postUpiData.hashCode() : 0);
            _result = 31 * _result + (this.notionalSchedule != null ? ((Object)((Object)this.notionalSchedule)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetType != null ? this.underlyingAssetType.hashCode() : 0);
            _result = 31 * _result + (this.instrumentType != null ? ((Object)((Object)this.instrumentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "NonReportable {enrichment=" + String.valueOf(this.enrichment) + ", preUpiData=" + String.valueOf(this.preUpiData) + ", postUpiData=" + String.valueOf(this.postUpiData) + ", notionalSchedule=" + String.valueOf((Object)this.notionalSchedule) + ", underlyingAssetType=" + this.underlyingAssetType + ", instrumentType=" + String.valueOf((Object)this.instrumentType) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + "}";
        }
    }
}

