/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.link.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=SortIdentifiersDefault.class)
public abstract class SortIdentifiers
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public String evaluate(Product product, Boolean isMin) {
        String sortedIdentifier = this.doEvaluate(product, isMin);
        return sortedIdentifier;
    }

    protected abstract String doEvaluate(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByName(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByOther(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFiltered(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByName(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByOther(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFiltered(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByName(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByOther(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFiltered(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByName(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByOther(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFiltered(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByName(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByOther(Product var1, Boolean var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFiltered(Product var1, Boolean var2);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1, Boolean var2);

    protected abstract MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product var1, Boolean var2);

    protected abstract MapperS<Boolean> IsIdentifierEmpty(Product var1, Boolean var2);

    protected abstract MapperC<String> comparison(Product var1, Boolean var2);

    public static class SortIdentifiersDefault
    extends SortIdentifiers {
        @Override
        protected String doEvaluate(Product product, Boolean isMin) {
            String sortedIdentifier = null;
            return this.assignOutput(sortedIdentifier, product, isMin);
        }

        protected String assignOutput(String sortedIdentifier, Product product, Boolean isMin) {
            sortedIdentifier = (Boolean)this.IsIdentifierEmpty(product, isMin).getOrDefault((Object)false) != false ? null : (isMin != null && isMin != false ? (String)this.comparison(product, isMin).min().get() : (String)this.comparison(product, isMin).max().get());
            return sortedIdentifier;
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByName(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.NAME), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFilteredByOther(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> indexIdentifierFiltered(Product product, Boolean isMin) {
            if (ExpressionOperators.notExists(this.indexIdentifierFilteredByName(product, isMin)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.indexIdentifierFilteredByOther(product, isMin);
            }
            return this.indexIdentifierFilteredByName(product, isMin);
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByName(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getLoan", _product -> _product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.NAME), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFilteredByOther(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getLoan", _product -> _product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> loanIdentifierFiltered(Product product, Boolean isMin) {
            if (ExpressionOperators.notExists(this.loanIdentifierFilteredByName(product, isMin)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.loanIdentifierFilteredByOther(product, isMin);
            }
            return this.loanIdentifierFilteredByName(product, isMin);
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByName(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.NAME), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFilteredByOther(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> contractualProductIdentifierFiltered(Product product, Boolean isMin) {
            if (ExpressionOperators.notExists(this.contractualProductIdentifierFilteredByName(product, isMin)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.contractualProductIdentifierFilteredByOther(product, isMin);
            }
            return this.contractualProductIdentifierFilteredByName(product, isMin);
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByName(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.NAME), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFilteredByOther(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> securityIdentifierFiltered(Product product, Boolean isMin) {
            if (ExpressionOperators.notExists(this.securityIdentifierFilteredByName(product, isMin)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.securityIdentifierFilteredByOther(product, isMin);
            }
            return this.securityIdentifierFilteredByName(product, isMin);
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByName(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.NAME), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFilteredByOther(Product product, Boolean isMin) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).filterItemNullSafe(identifier -> ExpressionOperators.areEqual((Mapper)identifier.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.OTHER), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketIdentifierFiltered(Product product, Boolean isMin) {
            if (ExpressionOperators.notExists(this.basketIdentifierFilteredByName(product, isMin)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.basketIdentifierFilteredByOther(product, isMin);
            }
            return this.basketIdentifierFilteredByName(product, isMin);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product, Boolean isMin) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends FieldWithMetaFloatingRateIndexEnum> floatingRateIndexes(Product product, Boolean isMin) {
            return this.interestRatePayouts(product, isMin).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex());
        }

        @Override
        protected MapperS<Boolean> IsIdentifierEmpty(Product product, Boolean isMin) {
            FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)this.indexIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)this.loanIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)this.contractualProductIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString3 = (FieldWithMetaString)this.securityIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString4 = (FieldWithMetaString)this.basketIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            return ExpressionOperators.notExists((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{fieldWithMetaString0 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString0.getValue()), fieldWithMetaString1 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString1.getValue()), fieldWithMetaString2 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString2.getValue()), fieldWithMetaString3 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString3.getValue()), (fieldWithMetaString4 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString4.getValue())).map("to-string", Object::toString)})).asMapper();
        }

        @Override
        protected MapperC<String> comparison(Product product, Boolean isMin) {
            FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)this.indexIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)this.loanIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)this.contractualProductIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString3 = (FieldWithMetaString)this.securityIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaString fieldWithMetaString4 = (FieldWithMetaString)this.basketIdentifierFiltered(product, isMin).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
            FieldWithMetaFloatingRateIndexEnum fieldWithMetaFloatingRateIndexEnum = (FieldWithMetaFloatingRateIndexEnum)this.floatingRateIndexes(product, isMin).get();
            return MapperC.of((MapperBuilder[])new MapperBuilder[]{fieldWithMetaString0 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString0.getValue()), fieldWithMetaString1 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString1.getValue()), fieldWithMetaString2 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString2.getValue()), fieldWithMetaString3 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString3.getValue()), (fieldWithMetaString4 == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaString4.getValue())).map("to-string", Object::toString), (fieldWithMetaFloatingRateIndexEnum == null ? MapperS.ofNull() : MapperS.of((Object)fieldWithMetaFloatingRateIndexEnum.getValue())).map("to-string", FloatingRateIndexEnum::toDisplayString)});
        }
    }
}

