/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.standards.iosco.cde.base.payment.PeriodicPayment;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PeriodicPaymentToCommonPeriodicPaymentDefault.class)
public abstract class PeriodicPaymentToCommonPeriodicPayment
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CommonPeriodicPayment evaluate(PeriodicPayment periodicPayment) {
        CommonPeriodicPayment commonPeriodicPayment;
        CommonPeriodicPayment.CommonPeriodicPaymentBuilder commonPeriodicPaymentBuilder = this.doEvaluate(periodicPayment);
        if (commonPeriodicPaymentBuilder == null) {
            commonPeriodicPayment = null;
        } else {
            commonPeriodicPayment = commonPeriodicPaymentBuilder.build();
            this.objectValidator.validate(CommonPeriodicPayment.class, (RosettaModelObject)commonPeriodicPayment);
        }
        return commonPeriodicPayment;
    }

    protected abstract CommonPeriodicPayment.CommonPeriodicPaymentBuilder doEvaluate(PeriodicPayment var1);

    public static class PeriodicPaymentToCommonPeriodicPaymentDefault
    extends PeriodicPaymentToCommonPeriodicPayment {
        @Override
        protected CommonPeriodicPayment.CommonPeriodicPaymentBuilder doEvaluate(PeriodicPayment periodicPayment) {
            CommonPeriodicPayment.CommonPeriodicPaymentBuilder commonPeriodicPayment = CommonPeriodicPayment.builder();
            return this.assignOutput(commonPeriodicPayment, periodicPayment);
        }

        protected CommonPeriodicPayment.CommonPeriodicPaymentBuilder assignOutput(CommonPeriodicPayment.CommonPeriodicPaymentBuilder commonPeriodicPayment, PeriodicPayment periodicPayment) {
            commonPeriodicPayment = (CommonPeriodicPayment.CommonPeriodicPaymentBuilder)this.toBuilder(CommonPeriodicPayment.builder().setFixedRateDayCountConvention((InterestComputationMethod4Code)((Object)MapperS.of((Object)periodicPayment).map("getFixedRateDayCountConvention", _periodicPayment -> _periodicPayment.getFixedRateDayCountConvention()).get())).setFloatingRateDayCountConvention((InterestComputationMethod4Code)((Object)MapperS.of((Object)periodicPayment).map("getFloatingRateDayCountConvention", _periodicPayment -> _periodicPayment.getFloatingRateDayCountConvention()).get())).setFixedRatePaymentFrequencyPeriod((FrequencyPeriodEnum)((Object)MapperS.of((Object)periodicPayment).map("getFixedRatePaymentFrequencyPeriod", _periodicPayment -> _periodicPayment.getFixedRatePaymentFrequencyPeriod()).get())).setFloatingRatePaymentFrequencyPeriod((FrequencyPeriodEnum)((Object)MapperS.of((Object)periodicPayment).map("getFloatingRatePaymentFrequencyPeriod", _periodicPayment -> _periodicPayment.getFloatingRatePaymentFrequencyPeriod()).get())).setFixedRatePaymentFrequencyPeriodMultiplier((Integer)MapperS.of((Object)periodicPayment).map("getFixedRatePaymentFrequencyPeriodMultiplier", _periodicPayment -> _periodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get()).setFloatingRatePaymentFrequencyPeriodMultiplier((Integer)MapperS.of((Object)periodicPayment).map("getFloatingRatePaymentFrequencyPeriodMultiplier", _periodicPayment -> _periodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get()).build());
            return Optional.ofNullable(commonPeriodicPayment).map(o -> o.prune()).orElse(null);
        }
    }
}

