/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsEquityOther;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.version3.price.reports.PriceNoFormatRule;
import javax.inject.Inject;

@ImplementedBy(value=IsDefaultPriceDefault.class)
public abstract class IsDefaultPrice
implements RosettaFunction {
    @Inject
    protected IsEquityOther isEquityOther;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected PriceNoFormatRule priceNoFormatRule;
    @Inject
    protected ProductForEvent productForEvent;

    public Boolean evaluate(TransactionReportInstruction transaction) {
        Boolean isDefaultPrice = this.doEvaluate(transaction);
        return isDefaultPrice;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    public static class IsDefaultPriceDefault
    extends IsDefaultPrice {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction transaction) {
            Boolean isDefaultPrice = null;
            return this.assignOutput(isDefaultPrice, transaction);
        }

        protected Boolean assignOutput(Boolean isDefaultPrice, TransactionReportInstruction transaction) {
            isDefaultPrice = ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate(this.productForEvent.evaluate(transaction)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate(this.productForEvent.evaluate(transaction))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOther.evaluate(this.productForEvent.evaluate(transaction)))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.priceNoFormatRule.evaluate(transaction))))).get();
            return isDefaultPrice;
        }
    }
}

