/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;

@ImplementedBy(value=SpreadLeg2_01_ValidationDefault.class)
public abstract class SpreadLeg2_01_Validation
implements RosettaFunction {
    public Boolean evaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, CommonContractType contractType, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
        Boolean result = this.doEvaluate(actionType, assetClass, contractType, fixedRateLeg1, fixedRateLeg2, spreadLeg1, spreadLeg2);
        return result;
    }

    protected abstract Boolean doEvaluate(ActionTypeEnum var1, CommonAssetClass var2, CommonContractType var3, BigDecimal var4, BigDecimal var5, PriceFormat var6, PriceFormat var7);

    public static class SpreadLeg2_01_ValidationDefault
    extends SpreadLeg2_01_Validation {
        @Override
        protected Boolean doEvaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, CommonContractType contractType, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
            Boolean result = null;
            return this.assignOutput(result, actionType, assetClass, contractType, fixedRateLeg1, fixedRateLeg2, spreadLeg1, spreadLeg2);
        }

        protected Boolean assignOutput(Boolean result, ActionTypeEnum actionType, CommonAssetClass assetClass, CommonContractType contractType, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
            result = ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)((Object)actionType)), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)contractType)), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWAP)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.notExists((Mapper)MapperS.of((Object)fixedRateLeg1)).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)fixedRateLeg2))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)spreadLeg1))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ExpressionOperators.exists((Mapper)MapperS.of((Object)spreadLeg2)).get() : (ExpressionOperators.exists((Mapper)MapperS.of((Object)fixedRateLeg2)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ExpressionOperators.notExists((Mapper)MapperS.of((Object)spreadLeg2)).get() : null)) : null;
            return result;
        }
    }
}

