/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.HKMAPartyInformation;
import java.util.List;
import java.util.stream.Collectors;

public class HKMAPartyInformationValidator
implements Validator<HKMAPartyInformation> {
    private List<ComparisonResult> getComparisonResults(HKMAPartyInformation o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkCardinality((String)"natureOfParty", (int)(o.getNatureOfParty() != null ? 1 : 0), (int)1, (int)1), ExpressionOperators.checkCardinality((String)"nonReportedTradePortfolio", (int)(o.getNonReportedTradePortfolio() != null ? 1 : 0), (int)0, (int)1), ExpressionOperators.checkCardinality((String)"corporateSector", (int)(o.getCorporateSector() != null ? 1 : 0), (int)0, (int)1)});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAPartyInformation o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"HKMAPartyInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.CARDINALITY, (String)"HKMAPartyInformation", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"HKMAPartyInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.CARDINALITY, (String)"HKMAPartyInformation", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

