/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReportableInformationTransactionInformationConditionCFTC")
@ImplementedBy(value=Default.class)
public interface ReportableInformationTransactionInformationConditionCFTC
extends Validator<ReportableInformation> {
    public static final String NAME = "ReportableInformationTransactionInformationConditionCFTC";
    public static final String DEFINITION = "filter transactionInformation -> supervisoryBody any = CFTC then transactionInformation distinct count <= 1";

    public static class NoOp
    implements ReportableInformationTransactionInformationConditionCFTC {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReportableInformationTransactionInformationConditionCFTC {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportableInformation reportableInformation) {
            ComparisonResult result = this.executeDataRule(reportableInformation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReportableInformationTransactionInformationConditionCFTC.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportableInformation", (RosettaPath)path, (String)ReportableInformationTransactionInformationConditionCFTC.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReportableInformationTransactionInformationConditionCFTC.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportableInformation", (RosettaPath)path, (String)ReportableInformationTransactionInformationConditionCFTC.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReportableInformation reportableInformation) {
            try {
                MapperS thenArg = MapperS.of((Object)reportableInformation).filterSingleNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation()).map("getSupervisoryBody", transactionInformation -> transactionInformation.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), (Mapper)MapperS.of((Object)((Object)SupervisoryBodyEnum.CFTC)), (CardinalityOperator)CardinalityOperator.Any).get());
                return ComparisonResult.of((Mapper)ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)thenArg.mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).asMapper());
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

