/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.dtcc;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.dtcc.CommonDTCCAdditionalFields;
import drr.regulation.common.dtcc.ProductGradeReport;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.dtcc.meta.DTCCAdditionalFieldsMeta;
import drr.standards.iso.OptionStyleEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DTCCAdditionalFields", builder=DTCCAdditionalFieldsBuilderImpl.class, version="6.19.3")
@RuneDataType(value="DTCCAdditionalFields", model="drr", builder=DTCCAdditionalFieldsBuilderImpl.class, version="6.19.3")
public interface DTCCAdditionalFields
extends CommonDTCCAdditionalFields {
    public static final DTCCAdditionalFieldsMeta metaData = new DTCCAdditionalFieldsMeta();

    public PartyIdentifierTypeEnum getTradeParty1IDType();

    public String getAllocationType();

    public String getUsiID();

    public String getUsiIDPrefix();

    public String getNewSDRIdentifier();

    public String getMessageID();

    public String getLeg1CommodityUnderlyerID();

    public String getLeg2CommodityUnderlyerID();

    public String getLeg1FloatingRateIndex();

    public String getLeg2FloatingRateIndex();

    public String getMessageTypeTransaction();

    public String getMessageTypePPD();

    public List<? extends UnderlyingAssetReport> getUnderlyingAsset();

    public UnderlyingAssetNameReport getUnderlyingAssetName();

    public String getExecutionVenueID();

    public PartyIdentifierTypeEnum getExecutionVenueIDType();

    public String getLeg1SettlementPeriod();

    public String getLoadType();

    public PartyIdentifierTypeEnum getTradeParty1BrokerIDType();

    public String getVersionTransaction();

    public String getVersionPPD();

    @Override
    public DTCCAdditionalFields build();

    @Override
    public DTCCAdditionalFieldsBuilder toBuilder();

    public static DTCCAdditionalFieldsBuilder builder() {
        return new DTCCAdditionalFieldsBuilderImpl();
    }

    default public RosettaMetaData<? extends DTCCAdditionalFields> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DTCCAdditionalFields> getType() {
        return DTCCAdditionalFields.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.class, this.getProductGrade(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocationType"), String.class, (Object)this.getAllocationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiID"), String.class, (Object)this.getUsiID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, (Object)this.getLeg1CommodityUnderlyerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, (Object)this.getLeg2CommodityUnderlyerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, (Object)this.getLeg1FloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, (Object)this.getLeg2FloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageTypeTransaction"), String.class, (Object)this.getMessageTypeTransaction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageTypePPD"), String.class, (Object)this.getMessageTypePPD(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, UnderlyingAssetReport.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAssetName"), processor, UnderlyingAssetNameReport.class, this.getUnderlyingAssetName(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueID"), String.class, (Object)this.getExecutionVenueID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getExecutionVenueIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, (Object)this.getLeg1SettlementPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("loadType"), String.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1BrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1BrokerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("versionTransaction"), String.class, (Object)this.getVersionTransaction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("versionPPD"), String.class, (Object)this.getVersionPPD(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DTCCAdditionalFieldsBuilderImpl
    extends CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsBuilderImpl
    implements DTCCAdditionalFieldsBuilder {
        protected PartyIdentifierTypeEnum tradeParty1IDType;
        protected String allocationType;
        protected String usiID;
        protected String usiIDPrefix;
        protected String newSDRIdentifier;
        protected String messageID;
        protected String leg1CommodityUnderlyerID;
        protected String leg2CommodityUnderlyerID;
        protected String leg1FloatingRateIndex;
        protected String leg2FloatingRateIndex;
        protected String messageTypeTransaction;
        protected String messageTypePPD;
        protected List<UnderlyingAssetReport.UnderlyingAssetReportBuilder> underlyingAsset = new ArrayList<UnderlyingAssetReport.UnderlyingAssetReportBuilder>();
        protected UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder underlyingAssetName;
        protected String executionVenueID;
        protected PartyIdentifierTypeEnum executionVenueIDType;
        protected String leg1SettlementPeriod;
        protected String loadType;
        protected PartyIdentifierTypeEnum tradeParty1BrokerIDType;
        protected String versionTransaction;
        protected String versionPPD;

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="allocationType")
        @RuneAttribute(value="allocationType")
        public String getAllocationType() {
            return this.allocationType;
        }

        @Override
        @RosettaAttribute(value="usiID")
        @RuneAttribute(value="usiID")
        public String getUsiID() {
            return this.usiID;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public String getNewSDRIdentifier() {
            return this.newSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public String getLeg1CommodityUnderlyerID() {
            return this.leg1CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public String getLeg2CommodityUnderlyerID() {
            return this.leg2CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg1FloatingRateIndex")
        @RuneAttribute(value="leg1FloatingRateIndex")
        public String getLeg1FloatingRateIndex() {
            return this.leg1FloatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="leg2FloatingRateIndex")
        @RuneAttribute(value="leg2FloatingRateIndex")
        public String getLeg2FloatingRateIndex() {
            return this.leg2FloatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="messageTypeTransaction")
        @RuneAttribute(value="messageTypeTransaction")
        public String getMessageTypeTransaction() {
            return this.messageTypeTransaction;
        }

        @Override
        @RosettaAttribute(value="messageTypePPD")
        @RuneAttribute(value="messageTypePPD")
        public String getMessageTypePPD() {
            return this.messageTypePPD;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public List<? extends UnderlyingAssetReport.UnderlyingAssetReportBuilder> getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public UnderlyingAssetReport.UnderlyingAssetReportBuilder getOrCreateUnderlyingAsset(int index) {
            if (this.underlyingAsset == null) {
                this.underlyingAsset = new ArrayList<UnderlyingAssetReport.UnderlyingAssetReportBuilder>();
            }
            return (UnderlyingAssetReport.UnderlyingAssetReportBuilder)this.getIndex(this.underlyingAsset, index, () -> {
                UnderlyingAssetReport.UnderlyingAssetReportBuilder newUnderlyingAsset = UnderlyingAssetReport.builder();
                return newUnderlyingAsset;
            });
        }

        @Override
        @RosettaAttribute(value="underlyingAssetName")
        @RuneAttribute(value="underlyingAssetName")
        public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getUnderlyingAssetName() {
            return this.underlyingAssetName;
        }

        @Override
        public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getOrCreateUnderlyingAssetName() {
            UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder result = this.underlyingAssetName != null ? this.underlyingAssetName : (this.underlyingAssetName = UnderlyingAssetNameReport.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionVenueID")
        @RuneAttribute(value="executionVenueID")
        public String getExecutionVenueID() {
            return this.executionVenueID;
        }

        @Override
        @RosettaAttribute(value="executionVenueIDType")
        @RuneAttribute(value="executionVenueIDType")
        public PartyIdentifierTypeEnum getExecutionVenueIDType() {
            return this.executionVenueIDType;
        }

        @Override
        @RosettaAttribute(value="leg1SettlementPeriod")
        @RuneAttribute(value="leg1SettlementPeriod")
        public String getLeg1SettlementPeriod() {
            return this.leg1SettlementPeriod;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public String getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1BrokerIDType")
        @RuneAttribute(value="tradeParty1BrokerIDType")
        public PartyIdentifierTypeEnum getTradeParty1BrokerIDType() {
            return this.tradeParty1BrokerIDType;
        }

        @Override
        @RosettaAttribute(value="versionTransaction")
        @RuneAttribute(value="versionTransaction")
        public String getVersionTransaction() {
            return this.versionTransaction;
        }

        @Override
        @RosettaAttribute(value="versionPPD")
        @RuneAttribute(value="versionPPD")
        public String getVersionPPD() {
            return this.versionPPD;
        }

        @Override
        @RosettaAttribute(value="clearingVenueIDType")
        @RuneAttribute(value="clearingVenueIDType")
        public DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum _clearingVenueIDType) {
            this.clearingVenueIDType = _clearingVenueIDType == null ? null : _clearingVenueIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ClearingBrokerIDType")
        @RuneAttribute(value="tradeParty1ClearingBrokerIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum _tradeParty1ClearingBrokerIDType) {
            this.tradeParty1ClearingBrokerIDType = _tradeParty1ClearingBrokerIDType == null ? null : _tradeParty1ClearingBrokerIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSubmittedForParty(String _submittedForParty) {
            this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeLegTypes")
        @RuneAttribute(value="tradeLegTypes")
        public DTCCAdditionalFieldsBuilder setTradeLegTypes(String _tradeLegTypes) {
            this.tradeLegTypes = _tradeLegTypes == null ? null : _tradeLegTypes;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
            if (_tradeParty2ReportingDestination != null) {
                this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int idx) {
            this.getIndex(this.tradeParty2ReportingDestination, idx, () -> _tradeParty2ReportingDestination);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            if (tradeParty2ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
                    this.tradeParty2ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations == null ? new ArrayList() : (List)tradeParty2ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum _secondaryAssetClass) {
            this.secondaryAssetClass = _secondaryAssetClass == null ? null : _secondaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public DTCCAdditionalFieldsBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public DTCCAdditionalFieldsBuilder setOptionType(String _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productID")
        @RuneAttribute(value="productID")
        public DTCCAdditionalFieldsBuilder setProductID(String _productID) {
            this.productID = _productID == null ? null : _productID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
            this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
            this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
            this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
            this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
            this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public DTCCAdditionalFieldsBuilder setSettlementType(String _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productGrade")
        @RuneAttribute(value="productGrade")
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade) {
            if (_productGrade != null) {
                this.productGrade.add(_productGrade.toBuilder());
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade, int idx) {
            this.getIndex(this.productGrade, idx, () -> _productGrade.toBuilder());
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> productGrades) {
            if (productGrades != null) {
                for (ProductGradeReport productGradeReport : productGrades) {
                    this.productGrade.add(productGradeReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productGrade")
        public DTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> productGrades) {
            this.productGrade = productGrades == null ? new ArrayList() : (List)productGrades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public DTCCAdditionalFieldsBuilder setDeliveryLocation(String _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityInstrumentID")
        @RuneAttribute(value="leg1CommodityInstrumentID")
        public DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String _leg1CommodityInstrumentID) {
            this.leg1CommodityInstrumentID = _leg1CommodityInstrumentID == null ? null : _leg1CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityInstrumentID")
        @RuneAttribute(value="leg2CommodityInstrumentID")
        public DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String _leg2CommodityInstrumentID) {
            this.leg2CommodityInstrumentID = _leg2CommodityInstrumentID == null ? null : _leg2CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterIDType")
        @RuneAttribute(value="responsibleDataSubmitterIDType")
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum _responsibleDataSubmitterIDType) {
            this.responsibleDataSubmitterIDType = _responsibleDataSubmitterIDType == null ? null : _responsibleDataSubmitterIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterID")
        @RuneAttribute(value="responsibleDataSubmitterID")
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String _responsibleDataSubmitterID) {
            this.responsibleDataSubmitterID = _responsibleDataSubmitterID == null ? null : _responsibleDataSubmitterID;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionNewTradeParty1Lei")
        @RuneAttribute(value="corporateActionNewTradeParty1Lei")
        public DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String _corporateActionNewTradeParty1Lei) {
            this.corporateActionNewTradeParty1Lei = _corporateActionNewTradeParty1Lei == null ? null : _corporateActionNewTradeParty1Lei;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentPayerIDType")
        @RuneAttribute(value="otherPaymentPayerIDType")
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType) {
            if (_otherPaymentPayerIDType != null) {
                this.otherPaymentPayerIDType.add(_otherPaymentPayerIDType);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType, int idx) {
            this.getIndex(this.otherPaymentPayerIDType, idx, () -> _otherPaymentPayerIDType);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            if (otherPaymentPayerIDTypes != null) {
                for (String toAdd : otherPaymentPayerIDTypes) {
                    this.otherPaymentPayerIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentPayerIDType")
        public DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            this.otherPaymentPayerIDType = otherPaymentPayerIDTypes == null ? new ArrayList() : (List)otherPaymentPayerIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentReceiverIDType")
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType) {
            if (_otherPaymentReceiverIDType != null) {
                this.otherPaymentReceiverIDType.add(_otherPaymentReceiverIDType);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType, int idx) {
            this.getIndex(this.otherPaymentReceiverIDType, idx, () -> _otherPaymentReceiverIDType);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            if (otherPaymentReceiverIDTypes != null) {
                for (String toAdd : otherPaymentReceiverIDTypes) {
                    this.otherPaymentReceiverIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            this.otherPaymentReceiverIDType = otherPaymentReceiverIDTypes == null ? new ArrayList() : (List)otherPaymentReceiverIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public DTCCAdditionalFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationType")
        @RuneAttribute(value="allocationType")
        public DTCCAdditionalFieldsBuilder setAllocationType(String _allocationType) {
            this.allocationType = _allocationType == null ? null : _allocationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiID")
        @RuneAttribute(value="usiID")
        public DTCCAdditionalFieldsBuilder setUsiID(String _usiID) {
            this.usiID = _usiID == null ? null : _usiID;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public DTCCAdditionalFieldsBuilder setUsiIDPrefix(String _usiIDPrefix) {
            this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public DTCCAdditionalFieldsBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public DTCCAdditionalFieldsBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String _leg1CommodityUnderlyerID) {
            this.leg1CommodityUnderlyerID = _leg1CommodityUnderlyerID == null ? null : _leg1CommodityUnderlyerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String _leg2CommodityUnderlyerID) {
            this.leg2CommodityUnderlyerID = _leg2CommodityUnderlyerID == null ? null : _leg2CommodityUnderlyerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1FloatingRateIndex")
        @RuneAttribute(value="leg1FloatingRateIndex")
        public DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String _leg1FloatingRateIndex) {
            this.leg1FloatingRateIndex = _leg1FloatingRateIndex == null ? null : _leg1FloatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2FloatingRateIndex")
        @RuneAttribute(value="leg2FloatingRateIndex")
        public DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String _leg2FloatingRateIndex) {
            this.leg2FloatingRateIndex = _leg2FloatingRateIndex == null ? null : _leg2FloatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageTypeTransaction")
        @RuneAttribute(value="messageTypeTransaction")
        public DTCCAdditionalFieldsBuilder setMessageTypeTransaction(String _messageTypeTransaction) {
            this.messageTypeTransaction = _messageTypeTransaction == null ? null : _messageTypeTransaction;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageTypePPD")
        @RuneAttribute(value="messageTypePPD")
        public DTCCAdditionalFieldsBuilder setMessageTypePPD(String _messageTypePPD) {
            this.messageTypePPD = _messageTypePPD == null ? null : _messageTypePPD;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport _underlyingAsset) {
            if (_underlyingAsset != null) {
                this.underlyingAsset.add(_underlyingAsset.toBuilder());
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport _underlyingAsset, int idx) {
            this.getIndex(this.underlyingAsset, idx, () -> _underlyingAsset.toBuilder());
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAssets) {
            if (underlyingAssets != null) {
                for (UnderlyingAssetReport underlyingAssetReport : underlyingAssets) {
                    this.underlyingAsset.add(underlyingAssetReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyingAsset")
        public DTCCAdditionalFieldsBuilder setUnderlyingAsset(List<? extends UnderlyingAssetReport> underlyingAssets) {
            this.underlyingAsset = underlyingAssets == null ? new ArrayList<UnderlyingAssetReport.UnderlyingAssetReportBuilder>() : (List)underlyingAssets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetName")
        @RuneAttribute(value="underlyingAssetName")
        public DTCCAdditionalFieldsBuilder setUnderlyingAssetName(UnderlyingAssetNameReport _underlyingAssetName) {
            this.underlyingAssetName = _underlyingAssetName == null ? null : _underlyingAssetName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueID")
        @RuneAttribute(value="executionVenueID")
        public DTCCAdditionalFieldsBuilder setExecutionVenueID(String _executionVenueID) {
            this.executionVenueID = _executionVenueID == null ? null : _executionVenueID;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueIDType")
        @RuneAttribute(value="executionVenueIDType")
        public DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum _executionVenueIDType) {
            this.executionVenueIDType = _executionVenueIDType == null ? null : _executionVenueIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1SettlementPeriod")
        @RuneAttribute(value="leg1SettlementPeriod")
        public DTCCAdditionalFieldsBuilder setLeg1SettlementPeriod(String _leg1SettlementPeriod) {
            this.leg1SettlementPeriod = _leg1SettlementPeriod == null ? null : _leg1SettlementPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public DTCCAdditionalFieldsBuilder setLoadType(String _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1BrokerIDType")
        @RuneAttribute(value="tradeParty1BrokerIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty1BrokerIDType(PartyIdentifierTypeEnum _tradeParty1BrokerIDType) {
            this.tradeParty1BrokerIDType = _tradeParty1BrokerIDType == null ? null : _tradeParty1BrokerIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="versionTransaction")
        @RuneAttribute(value="versionTransaction")
        public DTCCAdditionalFieldsBuilder setVersionTransaction(String _versionTransaction) {
            this.versionTransaction = _versionTransaction == null ? null : _versionTransaction;
            return this;
        }

        @Override
        @RosettaAttribute(value="versionPPD")
        @RuneAttribute(value="versionPPD")
        public DTCCAdditionalFieldsBuilder setVersionPPD(String _versionPPD) {
            this.versionPPD = _versionPPD == null ? null : _versionPPD;
            return this;
        }

        @Override
        public DTCCAdditionalFields build() {
            return new DTCCAdditionalFieldsImpl(this);
        }

        @Override
        public DTCCAdditionalFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder prune() {
            super.prune();
            this.underlyingAsset = this.underlyingAsset.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.underlyingAssetName != null && !this.underlyingAssetName.prune().hasData()) {
                this.underlyingAssetName = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getAllocationType() != null) {
                return true;
            }
            if (this.getUsiID() != null) {
                return true;
            }
            if (this.getUsiIDPrefix() != null) {
                return true;
            }
            if (this.getNewSDRIdentifier() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getLeg1CommodityUnderlyerID() != null) {
                return true;
            }
            if (this.getLeg2CommodityUnderlyerID() != null) {
                return true;
            }
            if (this.getLeg1FloatingRateIndex() != null) {
                return true;
            }
            if (this.getLeg2FloatingRateIndex() != null) {
                return true;
            }
            if (this.getMessageTypeTransaction() != null) {
                return true;
            }
            if (this.getMessageTypePPD() != null) {
                return true;
            }
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getUnderlyingAssetName() != null && this.getUnderlyingAssetName().hasData()) {
                return true;
            }
            if (this.getExecutionVenueID() != null) {
                return true;
            }
            if (this.getExecutionVenueIDType() != null) {
                return true;
            }
            if (this.getLeg1SettlementPeriod() != null) {
                return true;
            }
            if (this.getLoadType() != null) {
                return true;
            }
            if (this.getTradeParty1BrokerIDType() != null) {
                return true;
            }
            if (this.getVersionTransaction() != null) {
                return true;
            }
            return this.getVersionPPD() != null;
        }

        @Override
        public DTCCAdditionalFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DTCCAdditionalFieldsBuilder o = (DTCCAdditionalFieldsBuilder)other;
            merger.mergeRosetta(this.getUnderlyingAsset(), o.getUnderlyingAsset(), this::getOrCreateUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAssetName(), (RosettaModelObjectBuilder)o.getUnderlyingAssetName(), this::setUnderlyingAssetName);
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAllocationType(), (Object)o.getAllocationType(), this::setAllocationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiID(), (Object)o.getUsiID(), this::setUsiID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiIDPrefix(), (Object)o.getUsiIDPrefix(), this::setUsiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNewSDRIdentifier(), (Object)o.getNewSDRIdentifier(), this::setNewSDRIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg1CommodityUnderlyerID(), (Object)o.getLeg1CommodityUnderlyerID(), this::setLeg1CommodityUnderlyerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg2CommodityUnderlyerID(), (Object)o.getLeg2CommodityUnderlyerID(), this::setLeg2CommodityUnderlyerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg1FloatingRateIndex(), (Object)o.getLeg1FloatingRateIndex(), this::setLeg1FloatingRateIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg2FloatingRateIndex(), (Object)o.getLeg2FloatingRateIndex(), this::setLeg2FloatingRateIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageTypeTransaction(), (Object)o.getMessageTypeTransaction(), this::setMessageTypeTransaction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageTypePPD(), (Object)o.getMessageTypePPD(), this::setMessageTypePPD, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionVenueID(), (Object)o.getExecutionVenueID(), this::setExecutionVenueID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionVenueIDType(), (Object)o.getExecutionVenueIDType(), this::setExecutionVenueIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg1SettlementPeriod(), (Object)o.getLeg1SettlementPeriod(), this::setLeg1SettlementPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLoadType(), (Object)o.getLoadType(), this::setLoadType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1BrokerIDType(), (Object)o.getTradeParty1BrokerIDType(), this::setTradeParty1BrokerIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersionTransaction(), (Object)o.getVersionTransaction(), this::setVersionTransaction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersionPPD(), (Object)o.getVersionPPD(), this::setVersionPPD, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DTCCAdditionalFields _that = (DTCCAdditionalFields)this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.allocationType, _that.getAllocationType())) {
                return false;
            }
            if (!Objects.equals(this.usiID, _that.getUsiID())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.newSDRIdentifier, _that.getNewSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg1FloatingRateIndex, _that.getLeg1FloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.leg2FloatingRateIndex, _that.getLeg2FloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.messageTypeTransaction, _that.getMessageTypeTransaction())) {
                return false;
            }
            if (!Objects.equals(this.messageTypePPD, _that.getMessageTypePPD())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetName, _that.getUnderlyingAssetName())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueID, _that.getExecutionVenueID())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueIDType, _that.getExecutionVenueIDType())) {
                return false;
            }
            if (!Objects.equals(this.leg1SettlementPeriod, _that.getLeg1SettlementPeriod())) {
                return false;
            }
            if (!Objects.equals(this.loadType, _that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1BrokerIDType, _that.getTradeParty1BrokerIDType())) {
                return false;
            }
            if (!Objects.equals(this.versionTransaction, _that.getVersionTransaction())) {
                return false;
            }
            return Objects.equals(this.versionPPD, _that.getVersionPPD());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.allocationType != null ? this.allocationType.hashCode() : 0);
            _result = 31 * _result + (this.usiID != null ? this.usiID.hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.newSDRIdentifier != null ? this.newSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityUnderlyerID != null ? this.leg1CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityUnderlyerID != null ? this.leg2CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg1FloatingRateIndex != null ? this.leg1FloatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.leg2FloatingRateIndex != null ? this.leg2FloatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.messageTypeTransaction != null ? this.messageTypeTransaction.hashCode() : 0);
            _result = 31 * _result + (this.messageTypePPD != null ? this.messageTypePPD.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetName != null ? this.underlyingAssetName.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueID != null ? this.executionVenueID.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueIDType != null ? this.executionVenueIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.leg1SettlementPeriod != null ? this.leg1SettlementPeriod.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? this.loadType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1BrokerIDType != null ? this.tradeParty1BrokerIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.versionTransaction != null ? this.versionTransaction.hashCode() : 0);
            _result = 31 * _result + (this.versionPPD != null ? this.versionPPD.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DTCCAdditionalFieldsBuilder {tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", allocationType=" + this.allocationType + ", usiID=" + this.usiID + ", usiIDPrefix=" + this.usiIDPrefix + ", newSDRIdentifier=" + this.newSDRIdentifier + ", messageID=" + this.messageID + ", leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", leg1FloatingRateIndex=" + this.leg1FloatingRateIndex + ", leg2FloatingRateIndex=" + this.leg2FloatingRateIndex + ", messageTypeTransaction=" + this.messageTypeTransaction + ", messageTypePPD=" + this.messageTypePPD + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", underlyingAssetName=" + String.valueOf(this.underlyingAssetName) + ", executionVenueID=" + this.executionVenueID + ", executionVenueIDType=" + String.valueOf(this.executionVenueIDType) + ", leg1SettlementPeriod=" + this.leg1SettlementPeriod + ", loadType=" + this.loadType + ", tradeParty1BrokerIDType=" + String.valueOf(this.tradeParty1BrokerIDType) + ", versionTransaction=" + this.versionTransaction + ", versionPPD=" + this.versionPPD + "} " + super.toString();
        }
    }

    public static interface DTCCAdditionalFieldsBuilder
    extends DTCCAdditionalFields,
    CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsBuilder {
        public UnderlyingAssetReport.UnderlyingAssetReportBuilder getOrCreateUnderlyingAsset(int var1);

        public List<? extends UnderlyingAssetReport.UnderlyingAssetReportBuilder> getUnderlyingAsset();

        public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getOrCreateUnderlyingAssetName();

        @Override
        public UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder getUnderlyingAssetName();

        @Override
        public DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSubmittedForParty(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeLegTypes(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setComment1(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOptionType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setProductID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSettlementType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setDeliveryLocation(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> var1);

        public DTCCAdditionalFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum var1);

        public DTCCAdditionalFieldsBuilder setAllocationType(String var1);

        public DTCCAdditionalFieldsBuilder setUsiID(String var1);

        public DTCCAdditionalFieldsBuilder setUsiIDPrefix(String var1);

        public DTCCAdditionalFieldsBuilder setNewSDRIdentifier(String var1);

        public DTCCAdditionalFieldsBuilder setMessageID(String var1);

        public DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String var1);

        public DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String var1);

        public DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String var1);

        public DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String var1);

        public DTCCAdditionalFieldsBuilder setMessageTypeTransaction(String var1);

        public DTCCAdditionalFieldsBuilder setMessageTypePPD(String var1);

        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport var1);

        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(UnderlyingAssetReport var1, int var2);

        public DTCCAdditionalFieldsBuilder addUnderlyingAsset(List<? extends UnderlyingAssetReport> var1);

        public DTCCAdditionalFieldsBuilder setUnderlyingAsset(List<? extends UnderlyingAssetReport> var1);

        public DTCCAdditionalFieldsBuilder setUnderlyingAssetName(UnderlyingAssetNameReport var1);

        public DTCCAdditionalFieldsBuilder setExecutionVenueID(String var1);

        public DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum var1);

        public DTCCAdditionalFieldsBuilder setLeg1SettlementPeriod(String var1);

        public DTCCAdditionalFieldsBuilder setLoadType(String var1);

        public DTCCAdditionalFieldsBuilder setTradeParty1BrokerIDType(PartyIdentifierTypeEnum var1);

        public DTCCAdditionalFieldsBuilder setVersionTransaction(String var1);

        public DTCCAdditionalFieldsBuilder setVersionPPD(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.ProductGradeReportBuilder.class, this.getProductGrade(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocationType"), String.class, (Object)this.getAllocationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiID"), String.class, (Object)this.getUsiID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, (Object)this.getLeg1CommodityUnderlyerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, (Object)this.getLeg2CommodityUnderlyerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, (Object)this.getLeg1FloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, (Object)this.getLeg2FloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageTypeTransaction"), String.class, (Object)this.getMessageTypeTransaction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageTypePPD"), String.class, (Object)this.getMessageTypePPD(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, UnderlyingAssetReport.UnderlyingAssetReportBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAssetName"), processor, UnderlyingAssetNameReport.UnderlyingAssetNameReportBuilder.class, this.getUnderlyingAssetName(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueID"), String.class, (Object)this.getExecutionVenueID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getExecutionVenueIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1SettlementPeriod"), String.class, (Object)this.getLeg1SettlementPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("loadType"), String.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1BrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1BrokerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("versionTransaction"), String.class, (Object)this.getVersionTransaction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("versionPPD"), String.class, (Object)this.getVersionPPD(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public DTCCAdditionalFieldsBuilder prune();
    }

    public static class DTCCAdditionalFieldsImpl
    extends CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsImpl
    implements DTCCAdditionalFields {
        private final PartyIdentifierTypeEnum tradeParty1IDType;
        private final String allocationType;
        private final String usiID;
        private final String usiIDPrefix;
        private final String newSDRIdentifier;
        private final String messageID;
        private final String leg1CommodityUnderlyerID;
        private final String leg2CommodityUnderlyerID;
        private final String leg1FloatingRateIndex;
        private final String leg2FloatingRateIndex;
        private final String messageTypeTransaction;
        private final String messageTypePPD;
        private final List<? extends UnderlyingAssetReport> underlyingAsset;
        private final UnderlyingAssetNameReport underlyingAssetName;
        private final String executionVenueID;
        private final PartyIdentifierTypeEnum executionVenueIDType;
        private final String leg1SettlementPeriod;
        private final String loadType;
        private final PartyIdentifierTypeEnum tradeParty1BrokerIDType;
        private final String versionTransaction;
        private final String versionPPD;

        protected DTCCAdditionalFieldsImpl(DTCCAdditionalFieldsBuilder builder) {
            super(builder);
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.allocationType = builder.getAllocationType();
            this.usiID = builder.getUsiID();
            this.usiIDPrefix = builder.getUsiIDPrefix();
            this.newSDRIdentifier = builder.getNewSDRIdentifier();
            this.messageID = builder.getMessageID();
            this.leg1CommodityUnderlyerID = builder.getLeg1CommodityUnderlyerID();
            this.leg2CommodityUnderlyerID = builder.getLeg2CommodityUnderlyerID();
            this.leg1FloatingRateIndex = builder.getLeg1FloatingRateIndex();
            this.leg2FloatingRateIndex = builder.getLeg2FloatingRateIndex();
            this.messageTypeTransaction = builder.getMessageTypeTransaction();
            this.messageTypePPD = builder.getMessageTypePPD();
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.underlyingAssetName = Optional.ofNullable(builder.getUnderlyingAssetName()).map(f -> f.build()).orElse(null);
            this.executionVenueID = builder.getExecutionVenueID();
            this.executionVenueIDType = builder.getExecutionVenueIDType();
            this.leg1SettlementPeriod = builder.getLeg1SettlementPeriod();
            this.loadType = builder.getLoadType();
            this.tradeParty1BrokerIDType = builder.getTradeParty1BrokerIDType();
            this.versionTransaction = builder.getVersionTransaction();
            this.versionPPD = builder.getVersionPPD();
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="allocationType")
        @RuneAttribute(value="allocationType")
        public String getAllocationType() {
            return this.allocationType;
        }

        @Override
        @RosettaAttribute(value="usiID")
        @RuneAttribute(value="usiID")
        public String getUsiID() {
            return this.usiID;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public String getNewSDRIdentifier() {
            return this.newSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public String getLeg1CommodityUnderlyerID() {
            return this.leg1CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public String getLeg2CommodityUnderlyerID() {
            return this.leg2CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg1FloatingRateIndex")
        @RuneAttribute(value="leg1FloatingRateIndex")
        public String getLeg1FloatingRateIndex() {
            return this.leg1FloatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="leg2FloatingRateIndex")
        @RuneAttribute(value="leg2FloatingRateIndex")
        public String getLeg2FloatingRateIndex() {
            return this.leg2FloatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="messageTypeTransaction")
        @RuneAttribute(value="messageTypeTransaction")
        public String getMessageTypeTransaction() {
            return this.messageTypeTransaction;
        }

        @Override
        @RosettaAttribute(value="messageTypePPD")
        @RuneAttribute(value="messageTypePPD")
        public String getMessageTypePPD() {
            return this.messageTypePPD;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public List<? extends UnderlyingAssetReport> getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetName")
        @RuneAttribute(value="underlyingAssetName")
        public UnderlyingAssetNameReport getUnderlyingAssetName() {
            return this.underlyingAssetName;
        }

        @Override
        @RosettaAttribute(value="executionVenueID")
        @RuneAttribute(value="executionVenueID")
        public String getExecutionVenueID() {
            return this.executionVenueID;
        }

        @Override
        @RosettaAttribute(value="executionVenueIDType")
        @RuneAttribute(value="executionVenueIDType")
        public PartyIdentifierTypeEnum getExecutionVenueIDType() {
            return this.executionVenueIDType;
        }

        @Override
        @RosettaAttribute(value="leg1SettlementPeriod")
        @RuneAttribute(value="leg1SettlementPeriod")
        public String getLeg1SettlementPeriod() {
            return this.leg1SettlementPeriod;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public String getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1BrokerIDType")
        @RuneAttribute(value="tradeParty1BrokerIDType")
        public PartyIdentifierTypeEnum getTradeParty1BrokerIDType() {
            return this.tradeParty1BrokerIDType;
        }

        @Override
        @RosettaAttribute(value="versionTransaction")
        @RuneAttribute(value="versionTransaction")
        public String getVersionTransaction() {
            return this.versionTransaction;
        }

        @Override
        @RosettaAttribute(value="versionPPD")
        @RuneAttribute(value="versionPPD")
        public String getVersionPPD() {
            return this.versionPPD;
        }

        @Override
        public DTCCAdditionalFields build() {
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder toBuilder() {
            DTCCAdditionalFieldsBuilder builder = DTCCAdditionalFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DTCCAdditionalFieldsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getAllocationType()).ifPresent(builder::setAllocationType);
            Optional.ofNullable(this.getUsiID()).ifPresent(builder::setUsiID);
            Optional.ofNullable(this.getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
            Optional.ofNullable(this.getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getLeg1CommodityUnderlyerID()).ifPresent(builder::setLeg1CommodityUnderlyerID);
            Optional.ofNullable(this.getLeg2CommodityUnderlyerID()).ifPresent(builder::setLeg2CommodityUnderlyerID);
            Optional.ofNullable(this.getLeg1FloatingRateIndex()).ifPresent(builder::setLeg1FloatingRateIndex);
            Optional.ofNullable(this.getLeg2FloatingRateIndex()).ifPresent(builder::setLeg2FloatingRateIndex);
            Optional.ofNullable(this.getMessageTypeTransaction()).ifPresent(builder::setMessageTypeTransaction);
            Optional.ofNullable(this.getMessageTypePPD()).ifPresent(builder::setMessageTypePPD);
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getUnderlyingAssetName()).ifPresent(builder::setUnderlyingAssetName);
            Optional.ofNullable(this.getExecutionVenueID()).ifPresent(builder::setExecutionVenueID);
            Optional.ofNullable(this.getExecutionVenueIDType()).ifPresent(builder::setExecutionVenueIDType);
            Optional.ofNullable(this.getLeg1SettlementPeriod()).ifPresent(builder::setLeg1SettlementPeriod);
            Optional.ofNullable(this.getLoadType()).ifPresent(builder::setLoadType);
            Optional.ofNullable(this.getTradeParty1BrokerIDType()).ifPresent(builder::setTradeParty1BrokerIDType);
            Optional.ofNullable(this.getVersionTransaction()).ifPresent(builder::setVersionTransaction);
            Optional.ofNullable(this.getVersionPPD()).ifPresent(builder::setVersionPPD);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DTCCAdditionalFields _that = (DTCCAdditionalFields)this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.allocationType, _that.getAllocationType())) {
                return false;
            }
            if (!Objects.equals(this.usiID, _that.getUsiID())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.newSDRIdentifier, _that.getNewSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg1FloatingRateIndex, _that.getLeg1FloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.leg2FloatingRateIndex, _that.getLeg2FloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.messageTypeTransaction, _that.getMessageTypeTransaction())) {
                return false;
            }
            if (!Objects.equals(this.messageTypePPD, _that.getMessageTypePPD())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetName, _that.getUnderlyingAssetName())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueID, _that.getExecutionVenueID())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueIDType, _that.getExecutionVenueIDType())) {
                return false;
            }
            if (!Objects.equals(this.leg1SettlementPeriod, _that.getLeg1SettlementPeriod())) {
                return false;
            }
            if (!Objects.equals(this.loadType, _that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1BrokerIDType, _that.getTradeParty1BrokerIDType())) {
                return false;
            }
            if (!Objects.equals(this.versionTransaction, _that.getVersionTransaction())) {
                return false;
            }
            return Objects.equals(this.versionPPD, _that.getVersionPPD());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.allocationType != null ? this.allocationType.hashCode() : 0);
            _result = 31 * _result + (this.usiID != null ? this.usiID.hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.newSDRIdentifier != null ? this.newSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityUnderlyerID != null ? this.leg1CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityUnderlyerID != null ? this.leg2CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg1FloatingRateIndex != null ? this.leg1FloatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.leg2FloatingRateIndex != null ? this.leg2FloatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.messageTypeTransaction != null ? this.messageTypeTransaction.hashCode() : 0);
            _result = 31 * _result + (this.messageTypePPD != null ? this.messageTypePPD.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetName != null ? this.underlyingAssetName.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueID != null ? this.executionVenueID.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueIDType != null ? this.executionVenueIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.leg1SettlementPeriod != null ? this.leg1SettlementPeriod.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? this.loadType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1BrokerIDType != null ? this.tradeParty1BrokerIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.versionTransaction != null ? this.versionTransaction.hashCode() : 0);
            _result = 31 * _result + (this.versionPPD != null ? this.versionPPD.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DTCCAdditionalFields {tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", allocationType=" + this.allocationType + ", usiID=" + this.usiID + ", usiIDPrefix=" + this.usiIDPrefix + ", newSDRIdentifier=" + this.newSDRIdentifier + ", messageID=" + this.messageID + ", leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", leg1FloatingRateIndex=" + this.leg1FloatingRateIndex + ", leg2FloatingRateIndex=" + this.leg2FloatingRateIndex + ", messageTypeTransaction=" + this.messageTypeTransaction + ", messageTypePPD=" + this.messageTypePPD + ", underlyingAsset=" + String.valueOf(this.underlyingAsset) + ", underlyingAssetName=" + String.valueOf(this.underlyingAssetName) + ", executionVenueID=" + this.executionVenueID + ", executionVenueIDType=" + String.valueOf(this.executionVenueIDType) + ", leg1SettlementPeriod=" + this.leg1SettlementPeriod + ", loadType=" + this.loadType + ", tradeParty1BrokerIDType=" + String.valueOf(this.tradeParty1BrokerIDType) + ", versionTransaction=" + this.versionTransaction + ", versionPPD=" + this.versionPPD + "} " + super.toString();
        }
    }
}

