/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsReturnorPayoutTriggerCFD;
import javax.inject.Inject;

@ImplementedBy(value=ReturnorPayoutTriggerRuleDefault.class)
public abstract class ReturnorPayoutTriggerRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsReturnorPayoutTriggerCFD isReturnorPayoutTriggerCFD;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ReturnorPayoutTriggerRuleDefault
    extends ReturnorPayoutTriggerRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                Boolean _boolean = this.isReturnorPayoutTriggerCFD.evaluate((ReportableEvent)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)"Contract_for_Difference_CFD_");
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

