/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.reports.IsCSAAlignedRule;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1NotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2NotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadNotationLeg1RuleDefault.class)
public abstract class SpreadNotationLeg1Rule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected DefaultPercentageToDecimal defaultPercentageToDecimal;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected IsCSAAlignedRule isCSAAlignedRule;
    @Inject
    protected SpreadLeg1NotationEnumRule spreadLeg1NotationEnumRule;
    @Inject
    protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadNotationLeg1RuleDefault
    extends SpreadNotationLeg1Rule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            MapperS ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCSAAlignedRule.evaluate((TransactionReportInstruction)thenArg.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.spreadLeg1NotationEnumRule.evaluate((TransactionReportInstruction)thenArg.get()), false))) : MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.spreadLeg2NotationEnumRule.evaluate((TransactionReportInstruction)thenArg.get()), false)));
            output = (PriceNotationEnum)((Object)ifThenElseResult.get());
            return output;
        }
    }
}

