/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0027_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0027_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0027_01";
    public static final String DEFINITION = "if nonReportable -> postUpiData -> Header -> InstrumentType = Option or nonReportable -> instrumentType = Option then ((if leg1 -> notionalCurrency exists then [callCurrency, putCurrency] any = leg1 -> notionalCurrency else True) and (if leg2 -> notionalCurrency exists then [callCurrency, putCurrency] any = leg2 -> notionalCurrency else True))";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0027_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0027_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0027_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0027_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0027_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0027_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)cSATransactionReport).map("getCallCurrency", _cSATransactionReport -> _cSATransactionReport.getCallCurrency()), MapperS.of((Object)cSATransactionReport).map("getPutCurrency", _cSATransactionReport -> _cSATransactionReport.getPutCurrency())}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()), (CardinalityOperator)CardinalityOperator.Any) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                    ComparisonResult ifThenElseResult1 = ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)cSATransactionReport).map("getCallCurrency", _cSATransactionReport -> _cSATransactionReport.getCallCurrency()), MapperS.of((Object)cSATransactionReport).map("getPutCurrency", _cSATransactionReport -> _cSATransactionReport.getPutCurrency())}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()), (CardinalityOperator)CardinalityOperator.Any) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                    return ifThenElseResult0.and(ifThenElseResult1);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

