/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbReturnorPayoutTriggerEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0133_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0133_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0133_01";
    public static final String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if (nonReportable -> postUpiData -> Derived -> ReturnorPayoutTrigger exists and nonReportable -> postUpiData -> Derived -> ReturnorPayoutTrigger <> Contract_for_Difference_CFD_) or nonReportable -> returnorPayoutTrigger <> \"Contract_for_Difference_CFD_\" then finalContractualSettlementDate exists and finalContractualSettlementDate >= expirationDate else finalContractualSettlementDate is absent)";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0133_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0133_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0133_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0133_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0133_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0133_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getReturnorPayoutTrigger", annaDsbDerived -> annaDsbDerived.getReturnorPayoutTrigger())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getReturnorPayoutTrigger", annaDsbDerived -> annaDsbDerived.getReturnorPayoutTrigger()), (Mapper)MapperS.of((Object)((Object)AnnaDsbReturnorPayoutTriggerEnum.CONTRACT_FOR_DIFFERENCE_CFD)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getReturnorPayoutTrigger", cSANonReportable -> cSANonReportable.getReturnorPayoutTrigger()), (Mapper)MapperS.of((Object)"Contract_for_Difference_CFD_"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getFinalContractualSettlementDate", _cSATransactionReport -> _cSATransactionReport.getFinalContractualSettlementDate())).and(ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)cSATransactionReport).map("getFinalContractualSettlementDate", _cSATransactionReport -> _cSATransactionReport.getFinalContractualSettlementDate()), (Mapper)MapperS.of((Object)cSATransactionReport).map("getExpirationDate", _cSATransactionReport -> _cSATransactionReport.getExpirationDate()), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getFinalContractualSettlementDate", _cSATransactionReport -> _cSATransactionReport.getFinalContractualSettlementDate()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

