/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.OptionStyleEnum;
import javax.inject.Inject;

@ImplementedBy(value=OptionStyleRuleDefault.class)
public abstract class OptionStyleRule
implements ReportFunction<TransactionReportInstruction, OptionStyleEnum> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsCap isCap;
    @Inject
    protected IsFloor isFloor;
    @Inject
    protected IsOption isOption;
    @Inject
    protected ProductForEvent productForEvent;

    public OptionStyleEnum evaluate(TransactionReportInstruction input) {
        OptionStyleEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract OptionStyleEnum doEvaluate(TransactionReportInstruction var1);

    public static class OptionStyleRuleDefault
    extends OptionStyleRule {
        @Override
        protected OptionStyleEnum doEvaluate(TransactionReportInstruction input) {
            OptionStyleEnum output = null;
            return this.assignOutput(output, input);
        }

        protected OptionStyleEnum assignOutput(OptionStyleEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            output = (OptionStyleEnum)((Object)thenArg1.mapSingleToItem(item -> {
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isFloor.evaluate((Product)item.get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isCap.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)OptionStyleEnum.EURO));
                }
                Boolean _boolean = this.isOption.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).mapSingleToItem(_item -> {
                        if (ExpressionOperators.exists((Mapper)_item.map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((Object)OptionStyleEnum.AMER));
                        }
                        if (ExpressionOperators.exists((Mapper)_item.map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((Object)OptionStyleEnum.EURO));
                        }
                        if (ExpressionOperators.exists((Mapper)_item.map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((Object)OptionStyleEnum.BERM));
                        }
                        return MapperS.ofNull();
                    });
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

