/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.regulation.hkma.rewrite.margin.labels.HKMAMarginLabelProvider;
import drr.regulation.hkma.rewrite.margin.reports.ActionTypeRule;
import drr.regulation.hkma.rewrite.margin.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.hkma.rewrite.margin.reports.CollateralTimestampRule;
import drr.regulation.hkma.rewrite.margin.reports.CollateralisationCategoryRule;
import drr.regulation.hkma.rewrite.margin.reports.Counterparty1Rule;
import drr.regulation.hkma.rewrite.margin.reports.Counterparty2IdentifierFormatRule;
import drr.regulation.hkma.rewrite.margin.reports.Counterparty2IdentifierTypeIndicatorRule;
import drr.regulation.hkma.rewrite.margin.reports.Counterparty2NameRule;
import drr.regulation.hkma.rewrite.margin.reports.Counterparty2Rule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfExcessCollateralCollectedRule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfExcessCollateralPostedRule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfInitialMarginCollectedRule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfInitialMarginPostedRule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfVariationMarginCollectedRule;
import drr.regulation.hkma.rewrite.margin.reports.CurrencyOfVariationMarginPostedRule;
import drr.regulation.hkma.rewrite.margin.reports.EntityResponsibleForReportingRule;
import drr.regulation.hkma.rewrite.margin.reports.EventDateRule;
import drr.regulation.hkma.rewrite.margin.reports.EventTimestampRule;
import drr.regulation.hkma.rewrite.margin.reports.ExcessCollateralCollectedByTheCounterparty1Rule;
import drr.regulation.hkma.rewrite.margin.reports.ExcessCollateralPostedByTheCounterparty1Rule;
import drr.regulation.hkma.rewrite.margin.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.hkma.rewrite.margin.reports.InitialMarginCollectedByTheReportingCounterparty1PostHaircutRule;
import drr.regulation.hkma.rewrite.margin.reports.InitialMarginCollectedByTheReportingCounterparty1PreHaircutRule;
import drr.regulation.hkma.rewrite.margin.reports.InitialMarginPostedByTheReportingCounterparty1PostHaircutRule;
import drr.regulation.hkma.rewrite.margin.reports.InitialMarginPostedByTheReportingCounterparty1PreHaircutRule;
import drr.regulation.hkma.rewrite.margin.reports.NumberRecordsRule;
import drr.regulation.hkma.rewrite.margin.reports.PortfolioContainingNonReportableComponentIndicatorRule;
import drr.regulation.hkma.rewrite.margin.reports.ReportingTimestampRule;
import drr.regulation.hkma.rewrite.margin.reports.SubmitterIdentifierRule;
import drr.regulation.hkma.rewrite.margin.reports.TechnicalRecordIdRule;
import drr.regulation.hkma.rewrite.margin.reports.UniqueTransactionIdentifierRule;
import drr.regulation.hkma.rewrite.margin.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.hkma.rewrite.margin.reports.VariationMarginPostedByTheReportingCounterparty1PostHaircutRule;
import drr.regulation.hkma.rewrite.margin.reports.VariationMarginPostedByTheReportingCounterparty1PreHaircutRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.hkma.rewrite.margin", body="HKMA", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=HKMAMarginLabelProvider.class)
@ImplementedBy(value=HKMAMarginReportFunctionDefault.class)
public abstract class HKMAMarginReportFunction
implements ReportFunction<CollateralReportInstruction, HKMAMarginReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected CollateralTimestampRule collateralTimestampRule;
    @Inject
    protected CollateralisationCategoryRule collateralisationCategoryRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierFormatRule counterparty2IdentifierFormatRule;
    @Inject
    protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
    @Inject
    protected Counterparty2NameRule counterparty2NameRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
    @Inject
    protected CurrencyOfExcessCollateralPostedRule currencyOfExcessCollateralPostedRule;
    @Inject
    protected CurrencyOfInitialMarginCollectedRule currencyOfInitialMarginCollectedRule;
    @Inject
    protected CurrencyOfInitialMarginPostedRule currencyOfInitialMarginPostedRule;
    @Inject
    protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
    @Inject
    protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected EventDateRule eventDateRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected ExcessCollateralCollectedByTheCounterparty1Rule excessCollateralCollectedByTheCounterparty1Rule;
    @Inject
    protected ExcessCollateralPostedByTheCounterparty1Rule excessCollateralPostedByTheCounterparty1Rule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected InitialMarginCollectedByTheReportingCounterparty1PostHaircutRule initialMarginCollectedByTheReportingCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginCollectedByTheReportingCounterparty1PreHaircutRule initialMarginCollectedByTheReportingCounterparty1PreHaircutRule;
    @Inject
    protected InitialMarginPostedByTheReportingCounterparty1PostHaircutRule initialMarginPostedByTheReportingCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginPostedByTheReportingCounterparty1PreHaircutRule initialMarginPostedByTheReportingCounterparty1PreHaircutRule;
    @Inject
    protected NumberRecordsRule numberRecordsRule;
    @Inject
    protected PortfolioContainingNonReportableComponentIndicatorRule portfolioContainingNonReportableComponentIndicatorRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SubmitterIdentifierRule submitterIdentifierRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
    @Inject
    protected VariationMarginPostedByTheReportingCounterparty1PostHaircutRule variationMarginPostedByTheReportingCounterparty1PostHaircutRule;
    @Inject
    protected VariationMarginPostedByTheReportingCounterparty1PreHaircutRule variationMarginPostedByTheReportingCounterparty1PreHaircutRule;

    public HKMAMarginReport evaluate(CollateralReportInstruction input) {
        HKMAMarginReport output;
        HKMAMarginReport.HKMAMarginReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(HKMAMarginReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract HKMAMarginReport.HKMAMarginReportBuilder doEvaluate(CollateralReportInstruction var1);

    public static class HKMAMarginReportFunctionDefault
    extends HKMAMarginReportFunction {
        @Override
        protected HKMAMarginReport.HKMAMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
            HKMAMarginReport.HKMAMarginReportBuilder output = HKMAMarginReport.builder();
            return this.assignOutput(output, input);
        }

        protected HKMAMarginReport.HKMAMarginReportBuilder assignOutput(HKMAMarginReport.HKMAMarginReportBuilder output, CollateralReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameRule.evaluate(input));
            output.setCounterparty2IdentifierTypeIndicator(this.counterparty2IdentifierTypeIndicatorRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setInitialMarginPostedByTheReportingCounterparty1PreHaircut(this.initialMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginPostedByTheReportingCounterparty1PostHaircut(this.initialMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
            output.setCurrencyOfInitialMarginPosted(this.currencyOfInitialMarginPostedRule.evaluate(input));
            output.setInitialMarginCollectedByTheReportingCounterparty1PreHaircut(this.initialMarginCollectedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginCollectedByTheReportingCounterparty1PostHaircut(this.initialMarginCollectedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
            output.setCurrencyOfInitialMarginCollected(this.currencyOfInitialMarginCollectedRule.evaluate(input));
            output.setVariationMarginPostedByTheReportingCounterparty1PreHaircut(this.variationMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginPostedByTheReportingCounterparty1PostHaircut(this.variationMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
            output.setCurrencyOfVariationMarginPosted(this.currencyOfVariationMarginPostedRule.evaluate(input));
            output.setVariationMarginCollectedByTheReportingCounterparty1PreHaircut(this.variationMarginPostedByTheReportingCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginCollectedByTheReportingCounterparty1PostHaircut(this.variationMarginPostedByTheReportingCounterparty1PostHaircutRule.evaluate(input));
            output.setCurrencyOfVariationMarginCollected(this.currencyOfVariationMarginCollectedRule.evaluate(input));
            output.setExcessCollateralPostedByTheCounterparty1(this.excessCollateralPostedByTheCounterparty1Rule.evaluate(input));
            output.setCurrencyOfExcessCollateralPosted(this.currencyOfExcessCollateralPostedRule.evaluate(input));
            output.setExcessCollateralCollectedByTheCounterparty1(this.excessCollateralCollectedByTheCounterparty1Rule.evaluate(input));
            output.setCurrencyOfTheExcessCollateralCollected(this.currencyOfExcessCollateralCollectedRule.evaluate(input));
            output.setCollateralisationCategory(this.collateralisationCategoryRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventTimestamp(this.eventTimestampRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setPortfolioContainingNonReportableComponentIndicator(this.portfolioContainingNonReportableComponentIndicatorRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setSubmitterIdentifier(this.submitterIdentifierRule.evaluate(input));
            output.setEntityResponsibleForReporting(this.entityResponsibleForReportingRule.evaluate(input));
            output.setCollateralTimestamp(this.collateralTimestampRule.evaluate(input));
            output.setNumberRecords(null);
            output.setTechnicalRecordId(this.technicalRecordIdRule.evaluate(input));
            output.setEventDate(this.eventDateRule.evaluate(input));
            output.setCounterparty2IdentifierFormat(this.counterparty2IdentifierFormatRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

