/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0078a_01")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0078a_01
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0078a_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType then (if leg2 -> notionalAmountSchedule -> value count <> leg2 -> notionalAmountSchedule -> effectiveDate count then False else True) and if [CommonAssetClass -> CRDT, CommonAssetClass -> EQUI, CommonAssetClass -> CURR, CommonAssetClass -> INTR] any = assetClass and leg2 -> notionalAmountSchedule exists then leg2 -> notionalAmountSchedule -> value all >= 0 else True";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0078a_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0078a_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0078a_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0078a_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0078a_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0078a_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult0 = ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).map("getValue", notionalPeriod -> notionalPeriod.getValue()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? ComparisonResult.of((Mapper)MapperS.of((Object)false)) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                    ComparisonResult ifThenElseResult1 = ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.CRDT)), MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.CURR)), MapperS.of((Object)((Object)CommonAssetClass.INTR))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).map("getValue", notionalPeriod -> notionalPeriod.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                    return ifThenElseResult0.and(ifThenElseResult1);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

