/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0094_02")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0094_02
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0094_02";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and ((assetClass = CommonAssetClass -> INTR and [CommonContractType -> FORW, CommonContractType -> OTHR] any = contractType) or ([CommonAssetClass -> EQUI, CommonAssetClass -> COMM] any = assetClass and CommonContractType -> OTHR = contractType)) then (if leg1 -> fixedRate is absent and leg2 -> fixedRate is absent and leg1 -> spread is absent and leg2 -> spread is absent and strikePrice is absent and optionPremiumAmount is absent then price exists else if priceSchedule -> price exists then price exists)";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0094_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0094_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0094_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0094_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0094_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0094_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonContractType.FORW)), MapperS.of((Object)((Object)CommonContractType.OTHR))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.COMM))}), (Mapper)MapperS.of((Object)mASTransactionReport).map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)CommonContractType.OTHR)), (Mapper)MapperS.of((Object)mASTransactionReport).map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.All)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getFixedRate", commonLeg -> commonLeg.getFixedRate())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg1", _mASTransactionReport -> _mASTransactionReport.getLeg1()).map("getSpread", commonLeg -> commonLeg.getSpread()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getLeg2", _mASTransactionReport -> _mASTransactionReport.getLeg2()).map("getSpread", commonLeg -> commonLeg.getSpread()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getStrikePrice", _mASTransactionReport -> _mASTransactionReport.getStrikePrice()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)mASTransactionReport).map("getOptionPremiumAmount", _mASTransactionReport -> _mASTransactionReport.getOptionPremiumAmount()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice()));
                    }
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).mapC("getPriceSchedule", _mASTransactionReport -> _mASTransactionReport.getPriceSchedule()).map("getPrice", pricePeriod -> pricePeriod.getPrice())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)mASTransactionReport).map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice()));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

