/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.payment;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.standards.iosco.cde.base.payment.meta.OtherPaymentMeta;
import drr.standards.iso.PaymentType4Code;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OtherPayment", builder=OtherPaymentBuilderImpl.class, version="6.19.3")
@RuneDataType(value="OtherPayment", model="drr", builder=OtherPaymentBuilderImpl.class, version="6.19.3")
public interface OtherPayment
extends RosettaModelObject {
    public static final OtherPaymentMeta metaData = new OtherPaymentMeta();

    public PaymentType4Code getPaymentType();

    public BigDecimal getAmount();

    public ISOCurrencyCodeEnum getCurrency();

    public Date getDate();

    public String getPayer();

    public PartyIdentifierFormatEnum getPayerFormat();

    public String getReceiver();

    public PartyIdentifierFormatEnum getReceiverFormat();

    public String getPayerSchemeName();

    public String getReceiverSchemeName();

    public OtherPayment build();

    public OtherPaymentBuilder toBuilder();

    public static OtherPaymentBuilder builder() {
        return new OtherPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends OtherPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OtherPayment> getType() {
        return OtherPayment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paymentType"), PaymentType4Code.class, (Object)this.getPaymentType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), Date.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payer"), String.class, (Object)this.getPayer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerFormat"), PartyIdentifierFormatEnum.class, (Object)this.getPayerFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiver"), String.class, (Object)this.getReceiver(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverFormat"), PartyIdentifierFormatEnum.class, (Object)this.getReceiverFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerSchemeName"), String.class, (Object)this.getPayerSchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverSchemeName"), String.class, (Object)this.getReceiverSchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OtherPaymentBuilderImpl
    implements OtherPaymentBuilder {
        protected PaymentType4Code paymentType;
        protected BigDecimal amount;
        protected ISOCurrencyCodeEnum currency;
        protected Date date;
        protected String payer;
        protected PartyIdentifierFormatEnum payerFormat;
        protected String receiver;
        protected PartyIdentifierFormatEnum receiverFormat;
        protected String payerSchemeName;
        protected String receiverSchemeName;

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType4Code getPaymentType() {
            return this.paymentType;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public Date getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="payer")
        @RuneAttribute(value="payer")
        public String getPayer() {
            return this.payer;
        }

        @Override
        @RosettaAttribute(value="payerFormat")
        @RuneAttribute(value="payerFormat")
        public PartyIdentifierFormatEnum getPayerFormat() {
            return this.payerFormat;
        }

        @Override
        @RosettaAttribute(value="receiver")
        @RuneAttribute(value="receiver")
        public String getReceiver() {
            return this.receiver;
        }

        @Override
        @RosettaAttribute(value="receiverFormat")
        @RuneAttribute(value="receiverFormat")
        public PartyIdentifierFormatEnum getReceiverFormat() {
            return this.receiverFormat;
        }

        @Override
        @RosettaAttribute(value="payerSchemeName")
        @RuneAttribute(value="payerSchemeName")
        public String getPayerSchemeName() {
            return this.payerSchemeName;
        }

        @Override
        @RosettaAttribute(value="receiverSchemeName")
        @RuneAttribute(value="receiverSchemeName")
        public String getReceiverSchemeName() {
            return this.receiverSchemeName;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public OtherPaymentBuilder setPaymentType(PaymentType4Code _paymentType) {
            this.paymentType = _paymentType == null ? null : _paymentType;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public OtherPaymentBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public OtherPaymentBuilder setCurrency(ISOCurrencyCodeEnum _currency) {
            this.currency = _currency == null ? null : _currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public OtherPaymentBuilder setDate(Date _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="payer")
        @RuneAttribute(value="payer")
        public OtherPaymentBuilder setPayer(String _payer) {
            this.payer = _payer == null ? null : _payer;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerFormat")
        @RuneAttribute(value="payerFormat")
        public OtherPaymentBuilder setPayerFormat(PartyIdentifierFormatEnum _payerFormat) {
            this.payerFormat = _payerFormat == null ? null : _payerFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiver")
        @RuneAttribute(value="receiver")
        public OtherPaymentBuilder setReceiver(String _receiver) {
            this.receiver = _receiver == null ? null : _receiver;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverFormat")
        @RuneAttribute(value="receiverFormat")
        public OtherPaymentBuilder setReceiverFormat(PartyIdentifierFormatEnum _receiverFormat) {
            this.receiverFormat = _receiverFormat == null ? null : _receiverFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerSchemeName")
        @RuneAttribute(value="payerSchemeName")
        public OtherPaymentBuilder setPayerSchemeName(String _payerSchemeName) {
            this.payerSchemeName = _payerSchemeName == null ? null : _payerSchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverSchemeName")
        @RuneAttribute(value="receiverSchemeName")
        public OtherPaymentBuilder setReceiverSchemeName(String _receiverSchemeName) {
            this.receiverSchemeName = _receiverSchemeName == null ? null : _receiverSchemeName;
            return this;
        }

        @Override
        public OtherPayment build() {
            return new OtherPaymentImpl(this);
        }

        @Override
        public OtherPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public OtherPaymentBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getPaymentType() != null) {
                return true;
            }
            if (this.getAmount() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getDate() != null) {
                return true;
            }
            if (this.getPayer() != null) {
                return true;
            }
            if (this.getPayerFormat() != null) {
                return true;
            }
            if (this.getReceiver() != null) {
                return true;
            }
            if (this.getReceiverFormat() != null) {
                return true;
            }
            if (this.getPayerSchemeName() != null) {
                return true;
            }
            return this.getReceiverSchemeName() != null;
        }

        public OtherPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OtherPaymentBuilder o = (OtherPaymentBuilder)other;
            merger.mergeBasic((Object)this.getPaymentType(), (Object)o.getPaymentType(), this::setPaymentType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayer(), (Object)o.getPayer(), this::setPayer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayerFormat(), (Object)o.getPayerFormat(), this::setPayerFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReceiver(), (Object)o.getReceiver(), this::setReceiver, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReceiverFormat(), (Object)o.getReceiverFormat(), this::setReceiverFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayerSchemeName(), (Object)o.getPayerSchemeName(), this::setPayerSchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReceiverSchemeName(), (Object)o.getReceiverSchemeName(), this::setReceiverSchemeName, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OtherPayment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.paymentType, (Object)_that.getPaymentType())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.payer, _that.getPayer())) {
                return false;
            }
            if (!Objects.equals((Object)this.payerFormat, (Object)_that.getPayerFormat())) {
                return false;
            }
            if (!Objects.equals(this.receiver, _that.getReceiver())) {
                return false;
            }
            if (!Objects.equals((Object)this.receiverFormat, (Object)_that.getReceiverFormat())) {
                return false;
            }
            if (!Objects.equals(this.payerSchemeName, _that.getPayerSchemeName())) {
                return false;
            }
            return Objects.equals(this.receiverSchemeName, _that.getReceiverSchemeName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentType != null ? ((Object)((Object)this.paymentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.payer != null ? this.payer.hashCode() : 0);
            _result = 31 * _result + (this.payerFormat != null ? ((Object)((Object)this.payerFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.receiver != null ? this.receiver.hashCode() : 0);
            _result = 31 * _result + (this.receiverFormat != null ? ((Object)((Object)this.receiverFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.payerSchemeName != null ? this.payerSchemeName.hashCode() : 0);
            _result = 31 * _result + (this.receiverSchemeName != null ? this.receiverSchemeName.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OtherPaymentBuilder {paymentType=" + String.valueOf((Object)this.paymentType) + ", amount=" + String.valueOf(this.amount) + ", currency=" + String.valueOf(this.currency) + ", date=" + String.valueOf(this.date) + ", payer=" + this.payer + ", payerFormat=" + String.valueOf((Object)this.payerFormat) + ", receiver=" + this.receiver + ", receiverFormat=" + String.valueOf((Object)this.receiverFormat) + ", payerSchemeName=" + this.payerSchemeName + ", receiverSchemeName=" + this.receiverSchemeName + "}";
        }
    }

    public static interface OtherPaymentBuilder
    extends OtherPayment,
    RosettaModelObjectBuilder {
        public OtherPaymentBuilder setPaymentType(PaymentType4Code var1);

        public OtherPaymentBuilder setAmount(BigDecimal var1);

        public OtherPaymentBuilder setCurrency(ISOCurrencyCodeEnum var1);

        public OtherPaymentBuilder setDate(Date var1);

        public OtherPaymentBuilder setPayer(String var1);

        public OtherPaymentBuilder setPayerFormat(PartyIdentifierFormatEnum var1);

        public OtherPaymentBuilder setReceiver(String var1);

        public OtherPaymentBuilder setReceiverFormat(PartyIdentifierFormatEnum var1);

        public OtherPaymentBuilder setPayerSchemeName(String var1);

        public OtherPaymentBuilder setReceiverSchemeName(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paymentType"), PaymentType4Code.class, (Object)this.getPaymentType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), Date.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payer"), String.class, (Object)this.getPayer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerFormat"), PartyIdentifierFormatEnum.class, (Object)this.getPayerFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiver"), String.class, (Object)this.getReceiver(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverFormat"), PartyIdentifierFormatEnum.class, (Object)this.getReceiverFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerSchemeName"), String.class, (Object)this.getPayerSchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverSchemeName"), String.class, (Object)this.getReceiverSchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public OtherPaymentBuilder prune();
    }

    public static class OtherPaymentImpl
    implements OtherPayment {
        private final PaymentType4Code paymentType;
        private final BigDecimal amount;
        private final ISOCurrencyCodeEnum currency;
        private final Date date;
        private final String payer;
        private final PartyIdentifierFormatEnum payerFormat;
        private final String receiver;
        private final PartyIdentifierFormatEnum receiverFormat;
        private final String payerSchemeName;
        private final String receiverSchemeName;

        protected OtherPaymentImpl(OtherPaymentBuilder builder) {
            this.paymentType = builder.getPaymentType();
            this.amount = builder.getAmount();
            this.currency = builder.getCurrency();
            this.date = builder.getDate();
            this.payer = builder.getPayer();
            this.payerFormat = builder.getPayerFormat();
            this.receiver = builder.getReceiver();
            this.receiverFormat = builder.getReceiverFormat();
            this.payerSchemeName = builder.getPayerSchemeName();
            this.receiverSchemeName = builder.getReceiverSchemeName();
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType4Code getPaymentType() {
            return this.paymentType;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public Date getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="payer")
        @RuneAttribute(value="payer")
        public String getPayer() {
            return this.payer;
        }

        @Override
        @RosettaAttribute(value="payerFormat")
        @RuneAttribute(value="payerFormat")
        public PartyIdentifierFormatEnum getPayerFormat() {
            return this.payerFormat;
        }

        @Override
        @RosettaAttribute(value="receiver")
        @RuneAttribute(value="receiver")
        public String getReceiver() {
            return this.receiver;
        }

        @Override
        @RosettaAttribute(value="receiverFormat")
        @RuneAttribute(value="receiverFormat")
        public PartyIdentifierFormatEnum getReceiverFormat() {
            return this.receiverFormat;
        }

        @Override
        @RosettaAttribute(value="payerSchemeName")
        @RuneAttribute(value="payerSchemeName")
        public String getPayerSchemeName() {
            return this.payerSchemeName;
        }

        @Override
        @RosettaAttribute(value="receiverSchemeName")
        @RuneAttribute(value="receiverSchemeName")
        public String getReceiverSchemeName() {
            return this.receiverSchemeName;
        }

        @Override
        public OtherPayment build() {
            return this;
        }

        @Override
        public OtherPaymentBuilder toBuilder() {
            OtherPaymentBuilder builder = OtherPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OtherPaymentBuilder builder) {
            Optional.ofNullable(this.getPaymentType()).ifPresent(builder::setPaymentType);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getPayer()).ifPresent(builder::setPayer);
            Optional.ofNullable(this.getPayerFormat()).ifPresent(builder::setPayerFormat);
            Optional.ofNullable(this.getReceiver()).ifPresent(builder::setReceiver);
            Optional.ofNullable(this.getReceiverFormat()).ifPresent(builder::setReceiverFormat);
            Optional.ofNullable(this.getPayerSchemeName()).ifPresent(builder::setPayerSchemeName);
            Optional.ofNullable(this.getReceiverSchemeName()).ifPresent(builder::setReceiverSchemeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OtherPayment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.paymentType, (Object)_that.getPaymentType())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.payer, _that.getPayer())) {
                return false;
            }
            if (!Objects.equals((Object)this.payerFormat, (Object)_that.getPayerFormat())) {
                return false;
            }
            if (!Objects.equals(this.receiver, _that.getReceiver())) {
                return false;
            }
            if (!Objects.equals((Object)this.receiverFormat, (Object)_that.getReceiverFormat())) {
                return false;
            }
            if (!Objects.equals(this.payerSchemeName, _that.getPayerSchemeName())) {
                return false;
            }
            return Objects.equals(this.receiverSchemeName, _that.getReceiverSchemeName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentType != null ? ((Object)((Object)this.paymentType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.payer != null ? this.payer.hashCode() : 0);
            _result = 31 * _result + (this.payerFormat != null ? ((Object)((Object)this.payerFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.receiver != null ? this.receiver.hashCode() : 0);
            _result = 31 * _result + (this.receiverFormat != null ? ((Object)((Object)this.receiverFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.payerSchemeName != null ? this.payerSchemeName.hashCode() : 0);
            _result = 31 * _result + (this.receiverSchemeName != null ? this.receiverSchemeName.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OtherPayment {paymentType=" + String.valueOf((Object)this.paymentType) + ", amount=" + String.valueOf(this.amount) + ", currency=" + String.valueOf(this.currency) + ", date=" + String.valueOf(this.date) + ", payer=" + this.payer + ", payerFormat=" + String.valueOf((Object)this.payerFormat) + ", receiver=" + this.receiver + ", receiverFormat=" + String.valueOf((Object)this.receiverFormat) + ", payerSchemeName=" + this.payerSchemeName + ", receiverSchemeName=" + this.receiverSchemeName + "}";
        }
    }
}

