/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.price.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.functions.FormatToBaseOne18Rate;
import drr.standards.iosco.cde.base.price.functions.FormatToBaseOneRate;
import drr.standards.iosco.cde.base.price.functions.FormatToMax5Number;
import drr.standards.iosco.cde.base.price.functions.MultiplyPrice;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceFormatFromNotationDefault.class)
public abstract class PriceFormatFromNotation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected FormatToBaseOneRate formatToBaseOneRate;
    @Inject
    protected FormatToMax5Number formatToMax5Number;
    @Inject
    protected MultiplyPrice multiplyPrice;

    public PriceFormat evaluate(BigDecimal price, PriceNotationEnum notation) {
        PriceFormat priceFormat;
        PriceFormat.PriceFormatBuilder priceFormatBuilder = this.doEvaluate(price, notation);
        if (priceFormatBuilder == null) {
            priceFormat = null;
        } else {
            priceFormat = priceFormatBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)priceFormat);
        }
        return priceFormat;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(BigDecimal var1, PriceNotationEnum var2);

    public static class PriceFormatFromNotationDefault
    extends PriceFormatFromNotation {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(BigDecimal price, PriceNotationEnum notation) {
            PriceFormat.PriceFormatBuilder priceFormat = PriceFormat.builder();
            return this.assignOutput(priceFormat, price, notation);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder priceFormat, BigDecimal price, PriceNotationEnum notation) {
            MapperS thenArg0 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)notation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.multiplyPrice.evaluate(price, PriceNotationEnum.MONETARY)) : MapperS.ofNull();
            MapperS thenArg1 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)notation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.multiplyPrice.evaluate(price, PriceNotationEnum.DECIMAL)) : MapperS.ofNull();
            MapperS thenArg2 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)notation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.multiplyPrice.evaluate(price, PriceNotationEnum.PERCENTAGE)) : MapperS.ofNull();
            MapperS thenArg3 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)notation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.BASIS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.multiplyPrice.evaluate(price, PriceNotationEnum.BASIS)) : MapperS.ofNull();
            priceFormat = (PriceFormat.PriceFormatBuilder)this.toBuilder(PriceFormat.builder().setMonetary((BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg0.get())).get()).setDecimal((BigDecimal)MapperS.of((Object)this.formatToBaseOneRate.evaluate((BigDecimal)thenArg1.get())).get()).setPercentage((BigDecimal)MapperS.of((Object)this.formatToBaseOneRate.evaluate((BigDecimal)thenArg2.get())).get()).setBasis((BigDecimal)MapperS.of((Object)this.formatToMax5Number.evaluate((BigDecimal)thenArg3.get())).get()).build());
            return Optional.ofNullable(priceFormat).map(o -> o.prune()).orElse(null);
        }
    }
}

