/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.quantity.functions;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTradeForQuantityDefault.class)
public abstract class GetTradeForQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Trade evaluate(TransactionReportInstruction transactionReportInstruction) {
        Trade trade;
        Trade.TradeBuilder tradeBuilder = this.doEvaluate(transactionReportInstruction);
        if (tradeBuilder == null) {
            trade = null;
        } else {
            trade = tradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)trade);
        }
        return trade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(TransactionReportInstruction var1);

    public static class GetTradeForQuantityDefault
    extends GetTradeForQuantity {
        @Override
        protected Trade.TradeBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            Trade.TradeBuilder trade = Trade.builder();
            return this.assignOutput(trade, transactionReportInstruction);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, TransactionReportInstruction transactionReportInstruction) {
            Boolean _boolean = this.isActionTypeTERM.evaluate(transactionReportInstruction);
            trade = _boolean != null && _boolean != false ? (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)this.beforeTradeForEvent.evaluate(transactionReportInstruction)) : (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)this.tradeForEvent.evaluate(transactionReportInstruction));
            return Optional.ofNullable(trade).map(o -> o.prune()).orElse(null);
        }
    }
}

