/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version1.price.reports.PriceNoFormatRule;
import drr.standards.iosco.cde.version1.price.reports.PriceNotationRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceRuleDefault.class)
public abstract class PriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected PriceNoFormatRule priceNoFormatRule;
    @Inject
    protected PriceNotationRule priceNotationRule;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PriceRuleDefault
    extends PriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder(this.priceFormatFromNotation.evaluate(this.priceNoFormatRule.evaluate(input), this.priceNotationRule.evaluate(input)));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

