/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SpreadLeg1RuleDefault.class)
public abstract class SpreadLeg1Rule
implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg1 commodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected TradeForEvent tradeForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public PriceSchedule evaluate(TransactionReportInstruction input) {
        PriceSchedule output;
        PriceSchedule.PriceScheduleBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction var1);

    public static class SpreadLeg1RuleDefault
    extends SpreadLeg1Rule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
            PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
            return this.assignOutput(output, input);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.tradeForEvent.evaluate(input));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> {
                Boolean boolean0 = this.isCommoditySwapFloatFloat.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.commodityLeg1.evaluate((Product)item.get())).map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
                }
                Boolean boolean1 = this.isSingleCommodityPayoutProduct.evaluate((Product)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
                }
                Boolean boolean2 = this.isCommodityFloatingPriceForward.evaluate((Product)item.get());
                if (boolean2 != null && boolean2.booleanValue()) {
                    return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isIRSwaption.evaluate((Product)item.get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isCreditSwaption.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.interestRateLeg1.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
                }
                return MapperS.of((Object)this.interestRateLeg1.evaluate((Product)item.get())).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
            });
            ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = (ReferenceWithMetaPriceSchedule)thenArg2.mapSingleToItem(item -> item.map("getPrice", spreadSchedule -> spreadSchedule.getPrice())).get();
            output = referenceWithMetaPriceSchedule == null ? null : (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaPriceSchedule.getValue());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

