# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionStyle']


class OptionStyle(BaseDataClass):
    _CHOICE_ALIAS_MAP ={"relevantUnderlyingDate":[("americanExercise", rosetta_resolve_attr), ("bermudaExercise", rosetta_resolve_attr), ("europeanExercise", rosetta_resolve_attr)],"earliestExerciseTime":[("americanExercise", rosetta_resolve_attr), ("bermudaExercise", rosetta_resolve_attr), ("europeanExercise", rosetta_resolve_attr)],"expirationTime":[("americanExercise", rosetta_resolve_attr), ("bermudaExercise", rosetta_resolve_attr), ("europeanExercise", rosetta_resolve_attr)],"expirationTimeType":[("americanExercise", rosetta_resolve_attr), ("bermudaExercise", rosetta_resolve_attr), ("europeanExercise", rosetta_resolve_attr)]}
    """
    The qualification of the option style: American, Bermuda or European. FpML implements those features as part of a substitution group.
    """
    americanExercise: Optional[cdm.product.template.AmericanExercise.AmericanExercise] = Field(None, description="")
    bermudaExercise: Optional[cdm.product.template.BermudaExercise.BermudaExercise] = Field(None, description="")
    europeanExercise: Optional[cdm.product.template.EuropeanExercise.EuropeanExercise] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'americanExercise', 'bermudaExercise', 'europeanExercise', necessity=True)

import cdm 
import cdm.product.template.AmericanExercise
import cdm.product.template.BermudaExercise
import cdm.product.template.EuropeanExercise
