package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.meta.EnergyCommodityCoal2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of an energy derivative of type coal.
 * @version ${project.version}
 */
@RosettaDataType(value="EnergyCommodityCoal2__1", builder=EnergyCommodityCoal2__1.EnergyCommodityCoal2__1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="EnergyCommodityCoal2__1", model="iso20022", builder=EnergyCommodityCoal2__1.EnergyCommodityCoal2__1BuilderImpl.class, version="${project.version}")
public interface EnergyCommodityCoal2__1 extends RosettaModelObject {

	EnergyCommodityCoal2__1Meta metaData = new EnergyCommodityCoal2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType2Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType24Code getSubPdct();

	/*********************** Build Methods  ***********************/
	EnergyCommodityCoal2__1 build();
	
	EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder toBuilder();
	
	static EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder builder() {
		return new EnergyCommodityCoal2__1.EnergyCommodityCoal2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends EnergyCommodityCoal2__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends EnergyCommodityCoal2__1> getType() {
		return EnergyCommodityCoal2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType24Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface EnergyCommodityCoal2__1Builder extends EnergyCommodityCoal2__1, RosettaModelObjectBuilder {
		EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder setBasePdct(AssetClassProductType2Code basePdct);
		EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder setSubPdct(AssetClassSubProductType24Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType2Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType24Code.class, getSubPdct(), this);
		}
		

		EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder prune();
	}

	/*********************** Immutable Implementation of EnergyCommodityCoal2__1  ***********************/
	class EnergyCommodityCoal2__1Impl implements EnergyCommodityCoal2__1 {
		private final AssetClassProductType2Code basePdct;
		private final AssetClassSubProductType24Code subPdct;
		
		protected EnergyCommodityCoal2__1Impl(EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType24Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public EnergyCommodityCoal2__1 build() {
			return this;
		}
		
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder toBuilder() {
			EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityCoal2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityCoal2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of EnergyCommodityCoal2__1  ***********************/
	class EnergyCommodityCoal2__1BuilderImpl implements EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder {
	
		protected AssetClassProductType2Code basePdct;
		protected AssetClassSubProductType24Code subPdct;
		
		@Override
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		public AssetClassProductType2Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		public AssetClassSubProductType24Code getSubPdct() {
			return subPdct;
		}
		
		@RosettaAttribute(value="basePdct", isRequired=true)
		@RuneAttribute(value="basePdct", isRequired=true)
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder setBasePdct(AssetClassProductType2Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@RosettaAttribute(value="subPdct", isRequired=true)
		@RuneAttribute(value="subPdct", isRequired=true)
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder setSubPdct(AssetClassSubProductType24Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public EnergyCommodityCoal2__1 build() {
			return new EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Impl(this);
		}
		
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder o = (EnergyCommodityCoal2__1.EnergyCommodityCoal2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			EnergyCommodityCoal2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "EnergyCommodityCoal2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
