package iso20022.auth030.mas;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.mas.meta.TradeTransaction50__7Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version ${project.version}
 */
@RosettaDataType(value="TradeTransaction50__7", builder=TradeTransaction50__7.TradeTransaction50__7BuilderImpl.class, version="${project.version}")
@RuneDataType(value="TradeTransaction50__7", model="iso20022", builder=TradeTransaction50__7.TradeTransaction50__7BuilderImpl.class, version="${project.version}")
public interface TradeTransaction50__7 extends RosettaModelObject {

	TradeTransaction50__7Meta metaData = new TradeTransaction50__7Meta();

	/*********************** Getter Methods  ***********************/
	UniqueTransactionIdentifier2Choice__1 getTxId();
	DerivativeEvent6__1 getDerivEvt();

	/*********************** Build Methods  ***********************/
	TradeTransaction50__7 build();
	
	TradeTransaction50__7.TradeTransaction50__7Builder toBuilder();
	
	static TradeTransaction50__7.TradeTransaction50__7Builder builder() {
		return new TradeTransaction50__7.TradeTransaction50__7BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends TradeTransaction50__7> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends TradeTransaction50__7> getType() {
		return TradeTransaction50__7.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("txId"), processor, UniqueTransactionIdentifier2Choice__1.class, getTxId());
		processRosetta(path.newSubPath("derivEvt"), processor, DerivativeEvent6__1.class, getDerivEvt());
	}
	

	/*********************** Builder Interface  ***********************/
	interface TradeTransaction50__7Builder extends TradeTransaction50__7, RosettaModelObjectBuilder {
		UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getOrCreateTxId();
		@Override
		UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getTxId();
		DerivativeEvent6__1.DerivativeEvent6__1Builder getOrCreateDerivEvt();
		@Override
		DerivativeEvent6__1.DerivativeEvent6__1Builder getDerivEvt();
		TradeTransaction50__7.TradeTransaction50__7Builder setTxId(UniqueTransactionIdentifier2Choice__1 txId);
		TradeTransaction50__7.TradeTransaction50__7Builder setDerivEvt(DerivativeEvent6__1 derivEvt);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("txId"), processor, UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder.class, getTxId());
			processRosetta(path.newSubPath("derivEvt"), processor, DerivativeEvent6__1.DerivativeEvent6__1Builder.class, getDerivEvt());
		}
		

		TradeTransaction50__7.TradeTransaction50__7Builder prune();
	}

	/*********************** Immutable Implementation of TradeTransaction50__7  ***********************/
	class TradeTransaction50__7Impl implements TradeTransaction50__7 {
		private final UniqueTransactionIdentifier2Choice__1 txId;
		private final DerivativeEvent6__1 derivEvt;
		
		protected TradeTransaction50__7Impl(TradeTransaction50__7.TradeTransaction50__7Builder builder) {
			this.txId = ofNullable(builder.getTxId()).map(f->f.build()).orElse(null);
			this.derivEvt = ofNullable(builder.getDerivEvt()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="txId", isRequired=true)
		@RuneAttribute(value="txId", isRequired=true)
		public UniqueTransactionIdentifier2Choice__1 getTxId() {
			return txId;
		}
		
		@Override
		@RosettaAttribute(value="derivEvt", isRequired=true)
		@RuneAttribute(value="derivEvt", isRequired=true)
		public DerivativeEvent6__1 getDerivEvt() {
			return derivEvt;
		}
		
		@Override
		public TradeTransaction50__7 build() {
			return this;
		}
		
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder toBuilder() {
			TradeTransaction50__7.TradeTransaction50__7Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(TradeTransaction50__7.TradeTransaction50__7Builder builder) {
			ofNullable(getTxId()).ifPresent(builder::setTxId);
			ofNullable(getDerivEvt()).ifPresent(builder::setDerivEvt);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TradeTransaction50__7 _that = getType().cast(o);
		
			if (!Objects.equals(txId, _that.getTxId())) return false;
			if (!Objects.equals(derivEvt, _that.getDerivEvt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (txId != null ? txId.hashCode() : 0);
			_result = 31 * _result + (derivEvt != null ? derivEvt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TradeTransaction50__7 {" +
				"txId=" + this.txId + ", " +
				"derivEvt=" + this.derivEvt +
			'}';
		}
	}

	/*********************** Builder Implementation of TradeTransaction50__7  ***********************/
	class TradeTransaction50__7BuilderImpl implements TradeTransaction50__7.TradeTransaction50__7Builder {
	
		protected UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder txId;
		protected DerivativeEvent6__1.DerivativeEvent6__1Builder derivEvt;
		
		@Override
		@RosettaAttribute(value="txId", isRequired=true)
		@RuneAttribute(value="txId", isRequired=true)
		public UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getTxId() {
			return txId;
		}
		
		@Override
		public UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder getOrCreateTxId() {
			UniqueTransactionIdentifier2Choice__1.UniqueTransactionIdentifier2Choice__1Builder result;
			if (txId!=null) {
				result = txId;
			}
			else {
				result = txId = UniqueTransactionIdentifier2Choice__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="derivEvt", isRequired=true)
		@RuneAttribute(value="derivEvt", isRequired=true)
		public DerivativeEvent6__1.DerivativeEvent6__1Builder getDerivEvt() {
			return derivEvt;
		}
		
		@Override
		public DerivativeEvent6__1.DerivativeEvent6__1Builder getOrCreateDerivEvt() {
			DerivativeEvent6__1.DerivativeEvent6__1Builder result;
			if (derivEvt!=null) {
				result = derivEvt;
			}
			else {
				result = derivEvt = DerivativeEvent6__1.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="txId", isRequired=true)
		@RuneAttribute(value="txId", isRequired=true)
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder setTxId(UniqueTransactionIdentifier2Choice__1 _txId) {
			this.txId = _txId == null ? null : _txId.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="derivEvt", isRequired=true)
		@RuneAttribute(value="derivEvt", isRequired=true)
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder setDerivEvt(DerivativeEvent6__1 _derivEvt) {
			this.derivEvt = _derivEvt == null ? null : _derivEvt.toBuilder();
			return this;
		}
		
		@Override
		public TradeTransaction50__7 build() {
			return new TradeTransaction50__7.TradeTransaction50__7Impl(this);
		}
		
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder prune() {
			if (txId!=null && !txId.prune().hasData()) txId = null;
			if (derivEvt!=null && !derivEvt.prune().hasData()) derivEvt = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getTxId()!=null && getTxId().hasData()) return true;
			if (getDerivEvt()!=null && getDerivEvt().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public TradeTransaction50__7.TradeTransaction50__7Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			TradeTransaction50__7.TradeTransaction50__7Builder o = (TradeTransaction50__7.TradeTransaction50__7Builder) other;
			
			merger.mergeRosetta(getTxId(), o.getTxId(), this::setTxId);
			merger.mergeRosetta(getDerivEvt(), o.getDerivEvt(), this::setDerivEvt);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			TradeTransaction50__7 _that = getType().cast(o);
		
			if (!Objects.equals(txId, _that.getTxId())) return false;
			if (!Objects.equals(derivEvt, _that.getDerivEvt())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (txId != null ? txId.hashCode() : 0);
			_result = 31 * _result + (derivEvt != null ? derivEvt.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "TradeTransaction50__7Builder {" +
				"txId=" + this.txId + ", " +
				"derivEvt=" + this.derivEvt +
			'}';
		}
	}
}
