package drr.enrichment.upi.functions;

import cdm.base.staticdata.asset.rates.InflationRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaInflationRateIndexEnum;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InflationRateIndex.InflationRateIndexDefault.class)
public abstract class InflationRateIndex implements RosettaFunction {

	/**
	* @param interestRatePayout 
	* @return inflationRateIndex 
	*/
	public InflationRateIndexEnum evaluate(InterestRatePayout interestRatePayout) {
		InflationRateIndexEnum inflationRateIndex = doEvaluate(interestRatePayout);
		
		return inflationRateIndex;
	}

	protected abstract InflationRateIndexEnum doEvaluate(InterestRatePayout interestRatePayout);

	public static class InflationRateIndexDefault extends InflationRateIndex {
		@Override
		protected InflationRateIndexEnum doEvaluate(InterestRatePayout interestRatePayout) {
			InflationRateIndexEnum inflationRateIndex = null;
			return assignOutput(inflationRateIndex, interestRatePayout);
		}
		
		protected InflationRateIndexEnum assignOutput(InflationRateIndexEnum inflationRateIndex, InterestRatePayout interestRatePayout) {
			if (exists(MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).getOrDefault(false)) {
				final FieldWithMetaInflationRateIndexEnum fieldWithMetaInflationRateIndexEnum = MapperS.of(interestRatePayout).<RateSpecification>map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption == null ? null : referenceWithMetaFloatingRateOption.getValue()).<FieldWithMetaInflationRateIndexEnum>map("getInflationRateIndex", floatingRateOption -> floatingRateOption.getInflationRateIndex()).get();
				if (fieldWithMetaInflationRateIndexEnum == null) {
					inflationRateIndex = null;
				} else {
					inflationRateIndex = fieldWithMetaInflationRateIndexEnum.getValue();
				}
			} else {
				inflationRateIndex = null;
			}
			
			return inflationRateIndex;
		}
	}
}
