package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExtractCommodityClassification.ExtractCommodityClassificationDefault.class)
public abstract class ExtractCommodityClassification implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param economicTerms 
	* @param taxonomySource 
	* @param ordinal 
	* @return commodityClassification 
	*/
	public String evaluate(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
		String commodityClassification = doEvaluate(economicTerms, taxonomySource, ordinal);
		
		return commodityClassification;
	}

	protected abstract String doEvaluate(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperC<? extends ProductTaxonomy> taxonomy(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal);

	public static class ExtractCommodityClassificationDefault extends ExtractCommodityClassification {
		@Override
		protected String doEvaluate(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			String commodityClassification = null;
			return assignOutput(commodityClassification, economicTerms, taxonomySource, ordinal);
		}
		
		protected String assignOutput(String commodityClassification, EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			final MapperC<TaxonomyClassification> thenArg = MapperS.of(taxonomy(economicTerms, taxonomySource, ordinal).get()).<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<TaxonomyClassification>mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification())
				.filterItemNullSafe(item -> areEqual(item.<Integer>map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), MapperS.of(ordinal), CardinalityOperator.All).get());
			commodityClassification = MapperS.of(thenArg.get()).<String>map("getValue", taxonomyClassification -> taxonomyClassification.getValue()).get();
			
			return commodityClassification;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTerms)))).getOrDefault(false)) {
				return MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout())
					.first().<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
			}
			final Boolean boolean0 = qualify_Commodity_Option.evaluate(economicTerms);
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
			}
			final Boolean boolean1 = qualify_Commodity_Swaption.evaluate(economicTerms);
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(economicTermsForProduct.evaluate(MapperS.of(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout())
					.first().<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
			}
			final Boolean boolean2 = qualify_Commodity_Forward.evaluate(economicTerms);
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
			}
			return MapperS.of(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity());
		}
		
		@Override
		protected MapperC<? extends ProductTaxonomy> taxonomy(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			return commodityUnderlier(economicTerms, taxonomySource, ordinal).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ProductTaxonomy>mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy())
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(taxonomySource), CardinalityOperator.All).get());
		}
	}
}
