package drr.regulation.common.functions;

import cdm.base.datetime.DateRange;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.SchedulePeriod;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.base.quantity.NotionalPeriod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetReportableQuantityPeriodLeg1.GetReportableQuantityPeriodLeg1Default.class)
public abstract class GetReportableQuantityPeriodLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
	@Inject protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommodityOption isCommodityOption;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param trade 
	* @return reportablePeriod 
	*/
	public List<? extends NotionalPeriod> evaluate(Trade trade) {
		List<NotionalPeriod.NotionalPeriodBuilder> reportablePeriodBuilder = doEvaluate(trade);
		
		final List<? extends NotionalPeriod> reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
			objectValidator.validate(NotionalPeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(Trade trade);

	protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade);

	public static class GetReportableQuantityPeriodLeg1Default extends GetReportableQuantityPeriodLeg1 {
		@Override
		protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(Trade trade) {
			List<NotionalPeriod.NotionalPeriodBuilder> reportablePeriod = new ArrayList<>();
			return assignOutput(reportablePeriod, trade);
		}
		
		protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> reportablePeriod, Trade trade) {
			if (exists(customizedSchedule(trade)).getOrDefault(false)) {
				reportablePeriod.addAll(toBuilder(quantitySchedule(trade).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())
					.mapItem(quantityPeriod -> {
						final MapperC<SchedulePeriod> thenArg0 = customizedSchedule(trade).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod())
							.filterItemNullSafe(customPeriod -> areEqual(quantityPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()), customPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()), CardinalityOperator.All).get());
						final MapperS<SchedulePeriod> thenArg1 = MapperS.of(thenArg0.get());
						return thenArg1
							.mapSingleToItem(matchingCustomPeriod -> {
								final MapperS<BigDecimal> thenArg = quantityPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue());
								return MapperS.of(NotionalPeriod.builder()
									.setValue(MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get())
									.setEffectiveDate(matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()).get())
									.setEndDate(matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate()).get())
									.build());
							});
					}).getMulti()));
			} else {
				reportablePeriod.addAll(toBuilder(quantitySchedule(trade).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())
					.mapItem(quantityPeriod -> {
						final MapperS<BigDecimal> thenArg = quantityPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue());
						return MapperS.of(NotionalPeriod.builder()
							.setValue(MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get())
							.setEffectiveDate(quantityPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
							.setEndDate(null)
							.build());
					}).getMulti()));
			}
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade) {
			final Boolean boolean0 = qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(fixedPriceLeg1.evaluate(productForTrade.evaluate(trade))).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule());
			}
			final Boolean boolean1 = qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)));
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(commodityLeg1.evaluate(productForTrade.evaluate(trade))).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
			}
			final Boolean boolean2 = isSingleCommodityPayoutProduct.evaluate(productForTrade.evaluate(trade));
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
			}
			if (ComparisonResult.of(MapperS.of(isCommodityOption.evaluate(productForTrade.evaluate(trade)))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)))))).getOrDefault(false)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule()).get());
			}
			final Boolean boolean3 = isCommodityFloatingPriceForward.evaluate(MapperS.of(trade).<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
			if ((boolean3 == null ? false : boolean3)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
			}
			final Boolean boolean4 = isCommodityFixedPriceForward.evaluate(MapperS.of(trade).<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
			if ((boolean4 == null ? false : boolean4)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()).<CalculationSchedule>map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade) {
			if (ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Commodity.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)))))).getOrDefault(false)) {
				return MapperS.of(getLeg1ResolvablePriceQuantity.evaluate(trade)).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			}
			final Boolean _boolean = isSingleCommodityPayoutProduct.evaluate(productForTrade.evaluate(trade));
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<ResolvablePriceQuantity>map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			}
			return MapperS.<ReferenceWithMetaNonNegativeQuantitySchedule>ofNull();
		}
	}
}
