package drr.regulation.common.functions;

import cdm.event.common.CounterpartyPositionBusinessEvent;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PositionStateForEvent.PositionStateForEventDefault.class)
public abstract class PositionStateForEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param reportableEvent 
	* @return reportablePositionState 
	*/
	public CounterpartyPositionState evaluate(ReportableEvent reportableEvent) {
		CounterpartyPositionState.CounterpartyPositionStateBuilder reportablePositionStateBuilder = doEvaluate(reportableEvent);
		
		final CounterpartyPositionState reportablePositionState;
		if (reportablePositionStateBuilder == null) {
			reportablePositionState = null;
		} else {
			reportablePositionState = reportablePositionStateBuilder.build();
			objectValidator.validate(CounterpartyPositionState.class, reportablePositionState);
		}
		
		return reportablePositionState;
	}

	protected abstract CounterpartyPositionState.CounterpartyPositionStateBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class PositionStateForEventDefault extends PositionStateForEvent {
		@Override
		protected CounterpartyPositionState.CounterpartyPositionStateBuilder doEvaluate(ReportableEvent reportableEvent) {
			CounterpartyPositionState.CounterpartyPositionStateBuilder reportablePositionState = CounterpartyPositionState.builder();
			return assignOutput(reportablePositionState, reportableEvent);
		}
		
		protected CounterpartyPositionState.CounterpartyPositionStateBuilder assignOutput(CounterpartyPositionState.CounterpartyPositionStateBuilder reportablePositionState, ReportableEvent reportableEvent) {
			if (exists(MapperS.of(reportableEvent).<CounterpartyPositionState>map("getReportablePosition", _reportableEvent -> _reportableEvent.getReportablePosition())).getOrDefault(false)) {
				reportablePositionState = toBuilder(MapperS.of(reportableEvent).<CounterpartyPositionState>map("getReportablePosition", _reportableEvent -> _reportableEvent.getReportablePosition()).get());
			} else {
				reportablePositionState = toBuilder(MapperS.of(reportableEvent).<WorkflowStep>map("getOriginatingWorkflowStep", _reportableEvent -> _reportableEvent.getOriginatingWorkflowStep()).<CounterpartyPositionBusinessEvent>map("getCounterpartyPositionBusinessEvent", workflowStep -> workflowStep.getCounterpartyPositionBusinessEvent()).<CounterpartyPositionState>mapC("getAfter", counterpartyPositionBusinessEvent -> counterpartyPositionBusinessEvent.getAfter()).get());
			}
			
			return Optional.ofNullable(reportablePositionState)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
