package drr.regulation.common.trade.basket.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.math.BigDecimal;


@ImplementedBy(BasketConstituentNumberOfUnitsRule.BasketConstituentNumberOfUnitsRuleDefault.class)
public abstract class BasketConstituentNumberOfUnitsRule implements ReportFunction<BasketConstituent, BigDecimal> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(BasketConstituent input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(BasketConstituent input);

	public static class BasketConstituentNumberOfUnitsRuleDefault extends BasketConstituentNumberOfUnitsRule {
		@Override
		protected BigDecimal doEvaluate(BasketConstituent input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, BasketConstituent input) {
			final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule = MapperS.of(input).<ReferenceWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", basketConstituent -> basketConstituent.getQuantity()).get();
			output = (referenceWithMetaNonNegativeQuantitySchedule == null ? MapperS.<NonNegativeQuantitySchedule>ofNull() : MapperS.of(referenceWithMetaNonNegativeQuantitySchedule.getValue())).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get();
			
			return output;
		}
	}
}
