package drr.regulation.common.trade.contract.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.OptionTypeCode;
import javax.inject.Inject;


@ImplementedBy(OptionTypeRule.OptionTypeRuleDefault.class)
public abstract class OptionTypeRule implements ReportFunction<TransactionReportInstruction, OptionTypeCode> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCallOption isCallOption;
	@Inject protected IsCap isCap;
	@Inject protected IsFloor isFloor;
	@Inject protected IsOption isOption;
	@Inject protected IsPutOption isPutOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public OptionTypeCode evaluate(TransactionReportInstruction input) {
		OptionTypeCode output = doEvaluate(input);
		
		return output;
	}

	protected abstract OptionTypeCode doEvaluate(TransactionReportInstruction input);

	public static class OptionTypeRuleDefault extends OptionTypeRule {
		@Override
		protected OptionTypeCode doEvaluate(TransactionReportInstruction input) {
			OptionTypeCode output = null;
			return assignOutput(output, input);
		}
		
		protected OptionTypeCode assignOutput(OptionTypeCode output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isPutOption.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isFloor.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(OptionTypeCode.PUTO);
					}
					if (ComparisonResult.of(MapperS.of(isCallOption.evaluate(item.get()))).or(ComparisonResult.of(MapperS.of(isCap.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(OptionTypeCode.CALL);
					}
					final Boolean _boolean = isOption.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(OptionTypeCode.OTHR);
					}
					return MapperS.<OptionTypeCode>ofNull();
				}).get();
			
			return output;
		}
	}
}
